package com.artfess.yhxt.specialproject.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.yhxt.specialproject.model.BizProjectBeginApplyFor;
import com.artfess.yhxt.specialproject.vo.BizProjectBeginApplyForEngineeringVo;
import com.artfess.yhxt.specialproject.vo.BizProjectBeginApplyForVo;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.hasor.utils.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialproject.model.BizProjectBeginApplyFor;
import com.artfess.yhxt.specialproject.manager.BizProjectBeginApplyForManager;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

/**
 * 项目开工申请表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-11
 */
@RestController
@RequestMapping("/bizProjectBeginApplyFor/v1/")
@Api(tags = "项目开工申请")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizProjectBeginApplyForController extends BaseController<BizProjectBeginApplyForManager, BizProjectBeginApplyFor> {
    @Resource
    private PermissionUtils permissionUtils;

    @Resource
    private BizProjectBeginApplyForManager bizProjectBeginApplyForManager;

    @Resource
    private BaseContext baseContext;

    @RequestMapping(value = "/savebizProjectBeginApplyFor",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改项目开工申请信息",httpMethod = "POST")
    public CommonResult<String> saveEngineeringProject(@ApiParam(name = "bizProjectBeginApplyFor",value = "项目开工申请专项检查对象") @RequestBody BizProjectBeginApplyFor bizProjectBeginApplyFor) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(bizProjectBeginApplyFor.getId())){
            bizProjectBeginApplyFor.setIsDele("0");
            baseService.create(bizProjectBeginApplyFor);
        }else {
            baseService.update(bizProjectBeginApplyFor);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }


    @RequestMapping(value = "/saveVo",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改项目开工申请信息、附件",httpMethod = "POST")
    public CommonResult<String> saveVo(@ApiParam(name = "bizProjectBeginApplyForEngineeringVo",value = "项目开工申请专项检查对象") @RequestBody BizProjectBeginApplyForEngineeringVo bizProjectBeginApplyForEngineeringVo) throws Exception {
        String msg = "添加成功";
        BizProjectBeginApplyFor bizProjectBeginApplyFor = bizProjectBeginApplyForEngineeringVo.getBizProjectBeginApplyFor();
        if (StringUtils.isEmpty(bizProjectBeginApplyFor.getId())){
            bizProjectBeginApplyFor.setIsDele("0");
            baseService.saveVo(bizProjectBeginApplyForEngineeringVo);
        }else {
            baseService.updateVo(bizProjectBeginApplyForEngineeringVo);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }


    @GetMapping(value = "getVo/{id}")
    @ApiOperation(value = "根据ID查询项目开工申请、附件信息",httpMethod = "GET",notes = "根据ID查询项目开工申请、附件信息")
    public BizProjectBeginApplyForEngineeringVo getVo(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getVo(id);
    }


    @RequestMapping(value = "getJson",method = RequestMethod.POST,produces = {"application/json;charset=utf-8" })
    @ApiOperation(value = "分页查询项目开工申请信息",httpMethod ="POST")
    public PageList<BizProjectBeginApplyFor> getJson(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<BizProjectBeginApplyFor> queryFilter){
        queryFilter.addFilter("is_dele_","0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermissionByCreateOrgId(queryFilter);
        }
        PageList<BizProjectBeginApplyFor> pageList = baseService.queryBizProjectBeginApplyFor(queryFilter);
        return pageList;
    }

    @RequestMapping(value = "getQuery",method = RequestMethod.POST,produces = {"application/json;charset=utf-8" })
    @ApiOperation(value = "分页查询项目开工申请信息",httpMethod ="POST")
    public PageList<BizProjectBeginApplyFor> getQuery(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<BizProjectBeginApplyFor> queryFilter){
        queryFilter.addFilter("is_dele_","0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermissionByCreateOrgId(queryFilter);
        }
        PageList<BizProjectBeginApplyFor> pageList = baseService.query(queryFilter);
        return pageList;
    }

    @GetMapping(value = "get/{id}")
    @ApiOperation(value = "根据ID查询项目开工申请信息",httpMethod = "GET",notes = "根据ID查询项目开工申请信息")
    public BizProjectBeginApplyFor get(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getBizProjectBeginApplyForById(id);
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除项目开工申请信息",httpMethod = "DELETE",notes = "批量删除项目开工申请信息")
    public CommonResult<String> removes(@ApiParam(name = "ids",value = "对各主键用逗号分隔",required = true) @RequestParam String... ids) throws Exception{
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true,"删除成功");
    }

    @RequestMapping(value = "/updateBeginApplyFor",method = RequestMethod.DELETE,produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "逻辑删除项目开工申请信息",httpMethod = "DELETE",notes = "逻辑删除项目开工申请信息")
    public CommonResult<String> updateBeginApplyFor(@ApiParam(name = "ids",value = "ID集合以，隔开",required = true)
                                              @RequestParam(value = "ids",required = true)String ids)throws Exception{
        if (StringUtils.isNotBlank(ids)){
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizProjectBeginApplyFor> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_",idsList);
            updateWrapper.set("is_dele_","1");
            baseService.update(null,updateWrapper);
        }
        return new CommonResult<>(true,"删除成功");
    }

    @RequestMapping(value = "/savebizProjectBeginApplyForState",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "审核开工状态",httpMethod = "POST")
    public CommonResult<String> saveProjectState(@ApiParam(name = "bizProjectBeginApplyFor",value = "项目开工申请专项检查对象") @RequestBody BizProjectBeginApplyForVo vo) throws Exception {
        LocalDateTime nowTime = LocalDateTime.now();
        IUser user= ContextUtil.getCurrentUser();
        if (StringUtils.isNotEmpty(vo.getId())){
            UpdateWrapper<BizProjectBeginApplyFor> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("ID_",vo.getId());
            updateWrapper.set("CONFIRM_TIME_",nowTime);
            updateWrapper.set("CONFIRM_STATUS_ ",vo.getConfirmStatus());
            updateWrapper.set("CONFIRM_DESCRIPTION_",vo.getConfirmDescription());
            updateWrapper.set("CONFIRM_USER_ID_",user.getUserId());
            baseService.update(null,updateWrapper);
        }
        return new CommonResult<>(true,"审核成功");
    }

}
