package com.artfess.yhxt.check.regular.manager.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.manager.BizCulvertInformationManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.BizCulvertInformation;
import com.artfess.yhxt.check.detail.dao.CulvertRegularCheckDetailDao;
import com.artfess.yhxt.check.detail.manager.CulvertRegularCheckDetailManager;
import com.artfess.yhxt.check.detail.model.CulvertRegularCheckDetail;
import com.artfess.yhxt.check.regular.dao.CulvertRegularCheckDao;
import com.artfess.yhxt.check.regular.manager.CulvertRegularCheckManager;
import com.artfess.yhxt.check.regular.model.CulvertRegularCheck;
import com.artfess.yhxt.check.regular.vo.CulvertRegularCheckVo;
import com.artfess.yhxt.statistics.dao.SiteStatisticDao;
import com.artfess.yhxt.statistics.model.SiteStatistic;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 涵洞定期检查表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-17
 */
@Service
public class CulvertRegularCheckManagerImpl extends BaseManagerImpl<CulvertRegularCheckDao, CulvertRegularCheck> implements CulvertRegularCheckManager {

    @Resource
    private CulvertRegularCheckDetailDao culvertRegularCheckDetailDao;
    @Resource
    private CulvertRegularCheckDetailManager culvertRegularCheckDetailManager;
    @Resource
    private BizCulvertInformationManager culvertInformationManager;
    @Resource
    private SiteStatisticDao siteStatisticDao;
    @Resource
    private AccessoryManager accessoryManager;
    @Override
    public CulvertRegularCheckVo getCulvertRegularCheckById(String id) {

        CulvertRegularCheckVo culvertRegularCheckVo = new CulvertRegularCheckVo();
        CulvertRegularCheck culvertRegularCheck = this.getById(id);
        culvertRegularCheckVo.setCulvertRegularCheck(culvertRegularCheck);
        QueryWrapper<CulvertRegularCheckDetail> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(StringUtils.isNotBlank(culvertRegularCheck.getId()),"CULVERT_REGULAR_CHECK_ID_",id);
        List<CulvertRegularCheckDetail> culvertRegularCheckDetails = this.culvertRegularCheckDetailDao.selectList(queryWrapper);
        culvertRegularCheckVo.setCulvertRegularCheckDetails(culvertRegularCheckDetails);
        List<Accessory> accessories = this.accessoryManager.getAccessoryBySourceId(id);
        culvertRegularCheckVo.setAccessories(accessories);
        return culvertRegularCheckVo;
    }

    @Override
    public void updateCulvertRegularCheck(CulvertRegularCheckVo vo) {
        CulvertRegularCheck culvertRegularCheck = vo.getCulvertRegularCheck();
        culvertRegularCheck.setIsDele("0");
        this.update(culvertRegularCheck);

        List<CulvertRegularCheckDetail> list = vo.getCulvertRegularCheckDetails();
        for (CulvertRegularCheckDetail culvertRegularCheckDetail : list) {
            culvertRegularCheckDetail.setCulvertRegularCheckId(culvertRegularCheck.getId());
            this.culvertRegularCheckDetailManager.saveOrUpdate(culvertRegularCheckDetail);
        }
        //保存附件信息
        List<Accessory> accessoryList = vo.getAccessories();
        //资源ID
        String id = culvertRegularCheck.getId();
        if (null !=accessoryList && accessoryList.size() > 0) {
            //删除原来的附件信息
            this.accessoryManager.delAccessoryBySourceId(id);
            //获取附件信息
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveOrUpdateBatch(accessoryList);
        }
    }


    @Override
    public void saveCulvertRegularCheck(CulvertRegularCheckVo vo) {
        CulvertRegularCheck culvertRegularCheck = vo.getCulvertRegularCheck();
        culvertRegularCheck.setIsDele("0");
        this.saveOrUpdate(culvertRegularCheck);
        List<CulvertRegularCheckDetail> list = vo.getCulvertRegularCheckDetails();
        if (list.size()>0){
            for (CulvertRegularCheckDetail culvertRegularCheckDetail : list) {
                culvertRegularCheckDetail.setId(null);
                culvertRegularCheckDetail.setCulvertRegularCheckId(culvertRegularCheck.getId());
                this.culvertRegularCheckDetailManager.create(culvertRegularCheckDetail);
            }
        }
        //保存附件信息
        List<Accessory> accessoryList = vo.getAccessories();
        //资源ID
        String id = culvertRegularCheck.getId();
        if (null !=accessoryList && accessoryList.size() > 0) {
            //获取附件信息
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveBatch(accessoryList);
        }

    }

    @Override
    public PageList<CulvertRegularCheck> queryCulvertRegularCheck(QueryFilter<CulvertRegularCheck> queryFilter) {
        HashMap<String, Object> map = new HashMap<>();
        Map<String, Object> params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        IPage<CulvertRegularCheck> result = baseMapper.queryCulvertRegularCheck(convert2IPage(queryFilter.getPageBean()), map, convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);

    }

    @Override
    public void importExcelData(MultipartFile file, CulvertRegularCheck parseObject) {
        Assert.notNull(parseObject, "主数据不能为空");

        try (InputStream inputStream = file.getInputStream();) {
            // 获取数据
            List<CulvertRegularCheckDetail> data = ExcelImportUtil.importExcel(inputStream, CulvertRegularCheckDetail.class, new ImportParams());
            CulvertRegularCheckVo vo = new CulvertRegularCheckVo();
            vo.setCulvertRegularCheck(parseObject);
            vo.setCulvertRegularCheckDetails(data);
            saveCulvertRegularCheck(vo);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void saveSiteStatistic(CulvertRegularCheck culvertRegularCheck){
        SiteStatistic siteStatistic = new SiteStatistic();
        String culvertId = culvertRegularCheck.getCulvertId();
        BizCulvertInformation culvertInformation = culvertInformationManager.getById(culvertId);
        siteStatistic.setRoadSegmentId(culvertInformation.getRoadSegmentId());
        siteStatistic.setRoadSegmentName(culvertInformation.getRoadSegmentName());
        siteStatistic.setCompanyId(culvertInformation.getCompanyId());
        siteStatistic.setCompanyName(culvertInformation.getCompanyName());
        siteStatistic.setSiteCode(9);
        siteStatistic.setSiteName("涵洞定期检查");
        LocalDate checkDate = culvertRegularCheck.getCheckDate();
        String month = checkDate.format(DateTimeFormatter.ofPattern("yyyy-MM"));
        siteStatistic.setAccDateMonth(month);
        String year = checkDate.format(DateTimeFormatter.ofPattern("yyyy"));
        siteStatistic.setAccDateYear(year);


        siteStatistic.setComplete("1");
        siteStatistic.setCompleteNo("0");
        QueryWrapper<SiteStatistic> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(StringUtils.isNotEmpty(month), "ACC_DATE_MONTH_", month);
        queryWrapper.eq(StringUtils.isNotEmpty(year), "ACC_DATE_YEAR_", year);
        queryWrapper.eq(StringUtils.isNotEmpty(culvertInformation.getRoadSegmentId()), "ROAD_SEGMENT_ID_", culvertInformation.getRoadSegmentId());
        queryWrapper.eq(StringUtils.isNotEmpty(culvertInformation.getCompanyId()), "COMPANY_ID_", culvertInformation.getCompanyId());
        queryWrapper.eq("SITE_CODE_", 9);
        queryWrapper.eq("SITE_NAME_", "涵洞定期检查");
        List<SiteStatistic> siteStatistics = siteStatisticDao.selectList(queryWrapper);
        if (siteStatistics.size() > 0) {
            SiteStatistic statistic = siteStatistics.get(0);
            statistic.setComplete(String.valueOf(Integer.parseInt(statistic.getCompleteNo()) + 1));
            this.siteStatisticDao.update(siteStatistic, queryWrapper);
        } else {
            siteStatisticDao.insert(siteStatistic);
        }
    }
}
