package com.artfess.yhxt.basedata.manager;

import  com.artfess.yhxt.basedata.model.BizRoadsideFacilities;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.statistics.vo.Org4roadSideVO;
import com.artfess.yhxt.statistics.vo.Org4sideSlopelVO;

import java.util.List;

/**
 * 沿线设施 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-07-29
 */
public interface BizRoadsideFacilitiesManager extends BaseManager<BizRoadsideFacilities> {
    /**
     * @Description: 不分页查询沿线设施
     * @Param: sysActuator
     * @Return: java.util.List<com.artfess.portal.model.SysActuator>
     * @Author: wp
     * @Date: 2021/7/15
     */
    PageList<BizRoadsideFacilities> queryBizRoadsideFacilities(QueryFilter<BizRoadsideFacilities> queryFilter);

    void updateBizRoadsideFacilities(String id);
    //保存沿线设施
    void saveRoadside(BizRoadsideFacilities bizRoadsideFacilities);
    //修改沿线设施
    void updateRoadside(BizRoadsideFacilities bizRoadsideFacilities);
    //根据id查询沿线设施信息
    BizRoadsideFacilities getByFacilitiesId(String id);

    List<Org4roadSideVO> getRoadSideCount();
}
