package com.artfess.yhxt.basedata.controller;


import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.yhxt.basedata.dao.BizCourseDetailsDao;
import com.artfess.yhxt.basedata.manager.BizCourseDetailsManager;
import com.artfess.yhxt.basedata.model.BizCourseDetails;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;

import javax.annotation.Resource;
import java.util.*;

/**
 * 科目明细表 前端控制器
 *
 * @author wangping
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-07-30
 */
@RestController
@RequestMapping("/bizCourseDetails/v1/")
@Api(tags = "科目明细管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizCourseDetailsController extends BaseController<BizCourseDetailsManager, BizCourseDetails> {
    @Resource
    BizCourseDetailsManager bizCourseDetailsManager;
    @Resource
    BizCourseDetailsDao bizCourseDetailsDao;

    /**
     * 科目明细列表(分页条件查询)数据
     *
     * @param queryFilter
     * @return
     * @throws Exception PageJson
     * @throws
     */
    @PostMapping("/list")
    @ApiOperation(value = "科目明细数据列表", httpMethod = "POST", notes = "获取科目明细列表")
    public PageList<BizCourseDetails> list(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<BizCourseDetails> queryFilter) throws Exception {
        return bizCourseDetailsManager.query(queryFilter);
    }

    /**
     * 科目明细明细页面
     *
     * @param id
     * @return
     * @throws Exception ModelAndView
     */
    @GetMapping(value = "/get/{id}")
    @ApiOperation(value = "科目明细数据详情", httpMethod = "GET", notes = "科目明细数据详情")
    public BizCourseDetails get(@ApiParam(name = "id", value = "业务对象主键", required = true) @PathVariable String id) throws Exception {
        return bizCourseDetailsManager.get(id);
    }

    /**
     * 新增科目明细
     *
     * @param bizCourseDetails
     * @return
     * @throws Exception
     * @throws
     */
    @PostMapping(value = "/save")
    @ApiOperation(value = "新增,更新科目明细数据", httpMethod = "POST", notes = "新增,更新科目明细数据")
    public CommonResult<String> save(@ApiParam(name = "BizCourseDetails", value = "科目明细业务对象", required = true) @RequestBody BizCourseDetails bizCourseDetails) throws Exception {
        String msg = "添加科目明细成功";
        //编码唯一检验
        this.baseService.checkCode(bizCourseDetails);
        if (StringUtil.isEmpty(bizCourseDetails.getId())) {
            bizCourseDetails.setIsDele("0");
            HashMap<String, Object> map = new HashMap<>();
            IUser user = ContextUtil.getCurrentUser();
            if (ObjectUtils.isNotEmpty(user)) {
                map.put("tenant_id_", user.getTenantId());
            }
            int nextSequence = baseService.getNextSequence(map);
            bizCourseDetails.setSn(nextSequence);
            bizCourseDetailsManager.create(bizCourseDetails);
            String pcode = bizCourseDetails.getPcode();
            this.baseService.updateByPcode(pcode);
        } else {
            bizCourseDetailsManager.update(bizCourseDetails);
            msg = "更新科目明细成功";
        }
        return new CommonResult<String>(msg);
    }

    /**
     * 删除科目明细记录
     *
     * @param id
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/remove/{id}")
    @ApiOperation(value = "删除科目明细记录", httpMethod = "DELETE", notes = "删除科目明细记录")
    public CommonResult<String> remove(@ApiParam(name = "id", value = "业务主键", required = true) @PathVariable String id) throws Exception {
        BizCourseDetails bizCourseDetails = baseService.get(id);
        String pcode = bizCourseDetails.getPcode();
        bizCourseDetailsManager.remove(id);
        this.baseService.updateByPcode(pcode);
        return new CommonResult<String>(true, "删除成功");
    }

    /**
     * 批量删除科目明细记录
     *
     * @param ids
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除科目明细记录", httpMethod = "DELETE", notes = "批量删除科目明细记录")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "多个主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        for (int i = 0; i < ids.length; i++) {
            BizCourseDetails bizCourseDetails = baseService.get(ids[i]);
            if (bizCourseDetails != null) {
                String pcode = bizCourseDetails.getPcode();
                bizCourseDetailsManager.removeByIds(Arrays.asList(ids[i]));
                this.baseService.updateByPcode(pcode);
            }


        }
        return new CommonResult<String>(true, "删除成功");
    }

    @RequestMapping(value = "/getList", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "不分页查询科目明细信息", httpMethod = "POST")
    public PageList<BizCourseDetails> getList(@ApiParam(name = "queryFilter", value = "不分页查询信息") @RequestBody QueryFilter<BizCourseDetails> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE);
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        PageList<BizCourseDetails> road = baseService.queryBizCourseDetails(queryFilter);
        return road;
    }

    @RequestMapping(value = "/getJson", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "分页查询科目明细信息", httpMethod = "POST")
    public PageList<BizCourseDetails> getJson(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizCourseDetails> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageList<BizCourseDetails> pageList = baseService.queryBizCourseDetails(queryFilter);
        return pageList;
    }

    @RequestMapping(value = "updateBatch", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除", httpMethod = "POST", notes = "逻辑删除")
    public CommonResult<String> updateBatchBizCourseDetails(@ApiParam(name = "id", value = "科目明细ID", required = true) @RequestParam(value = "id", required = true) String id) throws Exception {

        if (StringUtils.isNotBlank(id))
            bizCourseDetailsManager.updateBizCourseDetails(id);
        return new CommonResult<>(true, "删除成功");
    }

    @RequestMapping(value = "updateCourseDetails", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量逻辑删除", httpMethod = "DELETE", notes = "批量逻辑删除")
    public CommonResult<String> updateCourseDetails(
            @ApiParam(name = "ids", value = "科目明细ID集合以，隔开", required = true)
            @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            this.baseService.checkHasChildren(idsList);
            UpdateWrapper<BizCourseDetails> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            bizCourseDetailsManager.update(null, updateWrapper);

        }
        //判断是否修改HAS_CHILDREN字段
        baseService.updateHasChildren(ids);

        return new CommonResult<>(true, "批量删除成功");
    }

    /**
     * 获取树形结构
     *
     * @param
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "get/getByParentId", method = RequestMethod.GET, produces = {
            "application/json; charset=utf-8"})
    @ApiOperation(value = "获取树形结构", httpMethod = "GET", notes = "根据父id获取获取树形结构")
    public List<BizCourseDetails> getByParentId(
            @ApiParam(name = "pCode", value = "父id", required = true) @RequestParam String pCode) {
//        if (BeanUtils.isEmpty(bizCourseDetailsManager.getByParentId(pCode))) {
//            throw new RuntimeException("根据科目明细id【" + pCode + "】没有找到对应的科目明细");
//        }
        return bizCourseDetailsManager.getByParentId(pCode);
    }

    @RequestMapping(value = "get/getByParentIdRoad", method = RequestMethod.GET, produces = {
            "application/json; charset=utf-8"})
    @ApiOperation(value = "根据pcde和路段id查询子集", httpMethod = "GET", notes = "根据pcde和路段id查询子集")
    public List<BizCourseDetails> getByParentIdRoad(
            @ApiParam(name = "pCode", value = "父id", required = false) @RequestParam String pCode,
            @ApiParam(name = "roadSegmentId", value = "父id", required = true) @RequestParam String roadSegmentId) {
//        if (BeanUtils.isEmpty(bizCourseDetailsManager.getByParentId(pCode))) {
//            throw new RuntimeException("根据科目明细id【" + pCode + "】没有找到对应的科目明细");
//        }
        return bizCourseDetailsManager.getByParentIdRoad(pCode,roadSegmentId);
    }


    @RequestMapping(value = "/updateBySn", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "修改排序号", httpMethod = "POST")
    public CommonResult<String> updateBySn(@ApiParam(name = "params", value = "排序参数：Key：ID，Value：排序号") @RequestBody HashMap<String, Integer> params) throws Exception {
        baseService.updateSequence(params);
        return new CommonResult<>(true, "排序完成");
    }

}
