package com.artfess.yhxt.assessment.manager.impl;

import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.poi.Excel;
import com.artfess.poi.editor.IFontEditor;
import com.artfess.poi.style.Align;
import com.artfess.poi.style.BorderStyle;
import com.artfess.poi.style.Color;
import com.artfess.poi.style.font.BoldWeight;
import com.artfess.poi.style.font.Font;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.model.SysMenu;
import com.artfess.uc.model.Role;
import com.artfess.yhxt.assessment.manager.CuringAssessmentDetailedManager;
import com.artfess.yhxt.assessment.model.CuringAssessment;
import com.artfess.yhxt.assessment.dao.CuringAssessmentDao;
import com.artfess.yhxt.assessment.manager.CuringAssessmentManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.assessment.model.CuringAssessmentDetailed;
import com.artfess.yhxt.assessment.vo.CuringAssessmentIVo;
import com.artfess.yhxt.check.regular.model.CulvertOftenCheck;
import com.artfess.yhxt.contract.model.BillOfQuantities;
import com.artfess.yhxt.contract.model.Contract;
import com.artfess.yhxt.contract.model.WorkOrderInformation;
import com.artfess.yhxt.contract.vo.WorkOrderDiseaseVo;
import com.artfess.yhxt.disease.model.Disease;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import lombok.val;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.functions.T;
import org.docx4j.wml.R;
import org.omg.CORBA.portable.ApplicationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.*;

/**
 * 养护考核表 服务实现类
 *
 * @author baseli
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-11-03
 */
@Service
public class CuringAssessmentManagerImpl extends BaseManagerImpl<CuringAssessmentDao, CuringAssessment> implements CuringAssessmentManager {

    @Resource
    private CuringAssessmentDetailedManager curingAssessmentDetailedManager;

    @Override
    public String saveCuringAssessment(CuringAssessmentIVo curingAssessmentIVo) {
        CuringAssessment curingAssessment = curingAssessmentIVo.getCuringAssessment();
        Integer assessmentContent = curingAssessment.getAssessmentQuarter();
        String errMsg = "";
        if (1 == assessmentContent) {
            LocalDate nowDate = LocalDate.now();
            curingAssessment.setStartDate(nowDate.plusMonths(1 - nowDate.getMonthValue()).with(TemporalAdjusters.firstDayOfMonth()));
            curingAssessment.setEndDate(nowDate.plusMonths(3 - nowDate.getMonthValue()).with(TemporalAdjusters.lastDayOfMonth()));
            errMsg = nowDate.getYear() +"年第一季度考核信息已经存在，不能重复添加";
        }
        if (2 == assessmentContent) {
            LocalDate nowDate = LocalDate.now();
            curingAssessment.setStartDate(nowDate.plusMonths(4 - nowDate.getMonthValue()).with(TemporalAdjusters.firstDayOfMonth()));
            curingAssessment.setEndDate(nowDate.plusMonths(6 - nowDate.getMonthValue()).with(TemporalAdjusters.lastDayOfMonth()));
            errMsg = nowDate.getYear() +"年第二季度考核信息已经存在，不能重复添加";
        }
        if (3 == assessmentContent) {
            LocalDate nowDate = LocalDate.now();
            curingAssessment.setStartDate(nowDate.plusMonths(7 - nowDate.getMonthValue()).with(TemporalAdjusters.firstDayOfMonth()));
            curingAssessment.setEndDate(nowDate.plusMonths(9 - nowDate.getMonthValue()).with(TemporalAdjusters.lastDayOfMonth()));
            errMsg = nowDate.getYear() +"年第三季度考核信息已经存在，不能重复添加";
        }
        if (4 == assessmentContent) {
            LocalDate nowDate = LocalDate.now();
            curingAssessment.setStartDate(nowDate.plusMonths(10 - nowDate.getMonthValue()).with(TemporalAdjusters.firstDayOfMonth()));
            curingAssessment.setEndDate(nowDate.plusMonths(12 - nowDate.getMonthValue()).with(TemporalAdjusters.lastDayOfMonth()));
            errMsg = nowDate.getYear() +"年第四季度考核信息已经存在，不能重复添加";
        }
        if (5 == assessmentContent) {
            LocalDate nowDate = LocalDate.now();
            curingAssessment.setStartDate(nowDate.plusMonths(10 - nowDate.getMonthValue()).with(TemporalAdjusters.firstDayOfMonth()));
            curingAssessment.setEndDate(nowDate.plusMonths(12 - nowDate.getMonthValue()).with(TemporalAdjusters.lastDayOfMonth()));
            errMsg = nowDate.getYear() +"年【"+curingAssessment.getStartDate()+"~"+curingAssessment.getEndDate()+"】考核信息已经存在，不能重复添加";
        }
        if (StringUtils.isEmpty(curingAssessment.getId())) {
            //判断当前年份，当前季度是否已经添加了
            QueryWrapper<CuringAssessment> queryCountWrapper = new QueryWrapper();
            queryCountWrapper.eq("ASSESSMENT_QUARTER_", assessmentContent);
            queryCountWrapper.eq("START_DATE_", curingAssessment.getStartDate());
            queryCountWrapper.eq("END_DATE_", curingAssessment.getEndDate());
            Integer count = this.baseMapper.selectCount(queryCountWrapper);
            if(count > 0){
                throw new RuntimeException(errMsg);
            }
            curingAssessment.setIsDele("0");
            baseMapper.insert(curingAssessment);
        } else {
            baseMapper.updateById(curingAssessment);
        }
        // 保存明细
        List<CuringAssessmentDetailed> curingAssessmentDetailedList = curingAssessmentIVo.getCuringAssessmentDetailedList();
        QueryWrapper<CuringAssessmentDetailed> queryWrapper = new QueryWrapper<CuringAssessmentDetailed>();
        queryWrapper.eq("ASSESSMENT_MAIN_ID_",curingAssessment.getId());
        curingAssessmentDetailedManager.remove(queryWrapper);
        for (CuringAssessmentDetailed curingAssessmentDetailed : curingAssessmentDetailedList){
            curingAssessmentDetailed.setAssessmentMainId(curingAssessment.getId());
            curingAssessmentDetailedManager.save(curingAssessmentDetailed);
        }
        //修改养护单状态为已考核,暂时没有使用
        return curingAssessment.getId();
    }

    @Override
    public HSSFWorkbook exportCuringOrder(List<WorkOrderDiseaseVo> workOrderDiseaseVoList) throws Exception{
        if(null == workOrderDiseaseVoList)workOrderDiseaseVoList = new ArrayList<>();
        Excel excel = new Excel();
        // 设置工作簿
        excel.setWorkingSheet(0);
        // 设置sheet标题
        excel.sheet().sheetName("养护工单明细表");// 重命名当前处于工作状态的表的名称
        HSSFSheet sheet = ExcelUtil.getHSSFSheet(excel.getWorkBook(), 0);
        Map<String,String> exportMap = new LinkedHashMap<>();
        exportMap.put("jobNumber","工单号");
        exportMap.put("roadSegmentName","路段");
        exportMap.put("position","位置");
        exportMap.put("name","合同");
        exportMap.put("issuer","签发人");
        exportMap.put("issueDate","签发日期");
        exportMap.put("demandFinishTime","要求修复日期");
        exportMap.put("taskContent","任务内容");
        exportMap.put("constructionStartPegK","施工起点桩号KM");
        exportMap.put("constructionEndPegK","施工结束桩号KM");
        exportMap.put("subjectName","科目名称");
        exportMap.put("fineSubjectName","细目名称");
        exportMap.put("spec","单位");
        exportMap.put("PRICE_","单价（元）");
        exportMap.put("amount","数量");
        exportMap.put("money","金额（元）");
        exportMap.put("auditPrice","审核单价（元）");
        exportMap.put("auditAmount","审核数量");
        exportMap.put("auditMoney","审核金额（元）");
        exportMap.put("receiverPrice","收方单价（元）");
        exportMap.put("receiverAmount","收方数量");
        exportMap.put("receiverMoney","收方金额（元）");
        exportMap.put("remarks","备注");
        //设置列表标题栏
        setSheetTitle(excel, "养护工单明细表");
        ExcelUtil.addMergeCellReign(sheet, 0, 0, 0, exportMap.size()-1);
        for(int r = 1;r < exportMap.size(); r++){
            excel.cell(0,r).border(BorderStyle.THIN, Color.BLACK);
        }
        //设置表头
        setSheetHeader(excel ,exportMap, 1, 0);
        int workOrderDiseaseVoListSize = workOrderDiseaseVoList.size();
        int currentRow = 2;
        for(int i=0;i<workOrderDiseaseVoListSize;i++){
            WorkOrderDiseaseVo workOrderDiseaseVo = workOrderDiseaseVoList.get(i);
            WorkOrderInformation workOrderInformation = workOrderDiseaseVo.getWorkOrderInformation(); //工单信息实体
            //List<Disease> diseaseList = workOrderDiseaseVo.getDiseaseList(); //病害信息
            Contract contract = workOrderDiseaseVo.getContract();   //养护合同
            List<BillOfQuantities> billOfQuantitiesList = workOrderDiseaseVo.getBillOfQuantities(); //工程量清单
            List<Map<String,Object>> billOfQuantitiesToMaplist = new ArrayList<>();
            if(BeanUtils.isNotEmpty(billOfQuantitiesList)){
                for (BillOfQuantities billOfQuantities : billOfQuantitiesList) {
                    billOfQuantitiesToMaplist.add(JsonUtil.toMap(JsonUtil.toJson(billOfQuantities)));
                }
            }
            // 1.写入工单信息
            setSheetCell(excel,  currentRow,  0,  workOrderInformation.getJobNumber());
            setSheetCell(excel,  currentRow,  1,  contract.getRoadSegmentName());
            setSheetCell(excel,  currentRow,  2,  workOrderInformation.getPosition());
            setSheetCell(excel,  currentRow,  3,  contract.getName());
            setSheetCell(excel,  currentRow,  4,  workOrderInformation.getIssuer());
            setSheetCell(excel,  currentRow,  5,  workOrderInformation.getIssueDate());
            setSheetCell(excel,  currentRow,  6,  workOrderInformation.getDemandFinishTime());
            setSheetCell(excel,  currentRow,  7,  workOrderInformation.getTaskContent());
            setSheetCell(excel,  currentRow,  8,  workOrderInformation.getConstructionStartPegK());
            setSheetCell(excel,  currentRow,  9,  workOrderInformation.getConstructionEndPegK());
            setSheetCell(excel,  currentRow,  exportMap.size()-1,  workOrderInformation.getRemarks());
            // 如果工单信息不止一行就合并单元格
            if(billOfQuantitiesList != null && billOfQuantitiesList.size() > 1){
                for(int r=currentRow+1;r<currentRow + billOfQuantitiesList.size();r++){
                    for (int j = 0; j < 10; j++) {
                        excel.cell(r,j).border(BorderStyle.THIN, Color.BLACK);
                        setSheetCell(excel,  r,  j,  "");
                    }
                    excel.cell(r,exportMap.size()-1).border(BorderStyle.THIN, Color.BLACK);
                    setSheetCell(excel,  r,  exportMap.size()-1,  "");
                    r++;
                }
                for (int j = 0; j < 10; j++) {
                    ExcelUtil.addMergeCellReign(sheet, currentRow, j, currentRow + billOfQuantitiesList.size()-1, j);
                }
                ExcelUtil.addMergeCellReign(sheet, currentRow, exportMap.size()-1,
                        currentRow + billOfQuantitiesList.size()-1, exportMap.size()-1);
            }
            // 2.写入计量信息
            Map<String,String> billOfQuantitiesMap = new LinkedHashMap<>();
            billOfQuantitiesMap.put("subjectName","科目名称");
            billOfQuantitiesMap.put("fineSubjectName","细目名称");
            billOfQuantitiesMap.put("spec","单位");
            billOfQuantitiesMap.put("PRICE_","单价（元）");
            billOfQuantitiesMap.put("amount","数量");
            billOfQuantitiesMap.put("money","金额（元）");
            billOfQuantitiesMap.put("auditPrice","审核单价（元）");
            billOfQuantitiesMap.put("auditAmount","审核数量");
            billOfQuantitiesMap.put("auditMoney","审核金额（元）");
            billOfQuantitiesMap.put("receiverPrice","收方单价（元）");
            billOfQuantitiesMap.put("receiverAmount","收方数量");
            billOfQuantitiesMap.put("receiverMoney","收方金额（元）");
            currentRow = setSheetDataNoHeader(excel, billOfQuantitiesMap, billOfQuantitiesToMaplist, currentRow, 10);

        }
        return excel.getWorkBook();
    }

    @Override
    public HSSFWorkbook exportCuringAssessment(String ids) throws Exception{
        QueryWrapper<CuringAssessment> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("ID_", ids.split(","));
        List<CuringAssessment> curingAssessments = baseMapper.selectList(queryWrapper);
        List<CuringAssessmentIVo> curingAssessmentIVoList = new ArrayList<>();

        if(BeanUtils.isNotEmpty(curingAssessments)){
            for (CuringAssessment curingAssessment : curingAssessments) {
                CuringAssessmentIVo curingAssessmentIVo = new CuringAssessmentIVo();
                curingAssessmentIVo.setCuringAssessment(curingAssessment);
                QueryWrapper<CuringAssessmentDetailed> queryDetailedWrapper = new QueryWrapper<CuringAssessmentDetailed>();
                queryDetailedWrapper.eq("ASSESSMENT_MAIN_ID_",curingAssessment.getId());
                List<CuringAssessmentDetailed> curingAssessmentDetailedList = curingAssessmentDetailedManager.list(queryDetailedWrapper);
                curingAssessmentIVo.setCuringAssessmentDetailedList(curingAssessmentDetailedList);
                curingAssessmentIVoList.add(curingAssessmentIVo);
            }
        }
        HSSFWorkbook hssfWorkbook = getHSSFWorkbook(curingAssessmentIVoList);
        return hssfWorkbook;
    }

    public HSSFWorkbook getHSSFWorkbook(List<CuringAssessmentIVo> curingAssessmentIVoList) throws Exception{
        Excel excel = new Excel();
        for(int i=0;i<curingAssessmentIVoList.size();i++){
            CuringAssessmentIVo curingAssessmentIVo = curingAssessmentIVoList.get(i);
            CuringAssessment curingAssessment = curingAssessmentIVo.getCuringAssessment();
            // 设置工作簿
            excel.setWorkingSheet(i);
            // 设置标题
            String sheetName = "";
            Integer assessmentQuarter = curingAssessment.getAssessmentQuarter();
            if(assessmentQuarter < 5 ){
                sheetName = "第"+ assessmentQuarter +"季度考核";
            }else {
                sheetName = curingAssessment.getStartDate() + "~" + curingAssessment.getEndDate();
            }
            excel.sheet().sheetName(sheetName);// 重命名当前处于工作状态的表的名称
            HSSFSheet sheet = ExcelUtil.getHSSFSheet(excel.getWorkBook(), 0);
            //设置标题栏
            setSheetTitle(excel, "日常养护考核评分表");
            ExcelUtil.addMergeCellReign(sheet, 0, 0, 0, 7);
            for(int r=1;r<8;r++){
                excel.cell(0,r).border(BorderStyle.THIN, Color.BLACK);
            }

            setSheetCell(excel,  1,  0,  "公    司:");
            setSheetCell(excel,  1,  1,  "");
            ExcelUtil.addMergeCellReign(sheet, 1, 0, 1, 1);

            setSheetCell(excel,  1,  2,  curingAssessment.getCompanyName());
            setSheetCell(excel,  1,  3,  "");
            ExcelUtil.addMergeCellReign(sheet, 1, 2, 1, 3);

            setSheetCell(excel,  1,  4,  "路    段:");
            setSheetCell(excel,  1,  5,  "");
            ExcelUtil.addMergeCellReign(sheet, 1, 4, 1, 5);

            setSheetCell(excel,  1,  6,  curingAssessment.getRoadName());
            setSheetCell(excel,  1,  7,  "");
            ExcelUtil.addMergeCellReign(sheet, 1, 6, 1, 7);

            setSheetCell(excel,  2,  0,  "合同名称:");
            setSheetCell(excel,  2,  1,  "");
            ExcelUtil.addMergeCellReign(sheet, 2, 0, 2, 1);

            setSheetCell(excel,  2,  2,  curingAssessment.getItemName());
            setSheetCell(excel,  2,  3,  "");
            ExcelUtil.addMergeCellReign(sheet, 2, 2, 2, 3);

            setSheetCell(excel,  2,  4,  "合同编号:");
            setSheetCell(excel,  2,  5,  "");
            ExcelUtil.addMergeCellReign(sheet, 2, 4, 2, 5);

            setSheetCell(excel,  2,  6,  curingAssessment.getItemNomber());
            setSheetCell(excel,  2,  7,  "");
            ExcelUtil.addMergeCellReign(sheet, 2, 6, 2, 7);
            //添加明细数据
            List<CuringAssessmentDetailed> curingAssessmentDetailedList = curingAssessmentIVo.getCuringAssessmentDetailedList();
            List<Map<String,Object>> list = new ArrayList<>();
            if(BeanUtils.isNotEmpty(curingAssessmentDetailedList)){
                for (CuringAssessmentDetailed curingAssessmentDetailed : curingAssessmentDetailedList) {
                    list.add(JsonUtil.toMap(JsonUtil.toJson(curingAssessmentDetailed)));
                }
            }
            Map<String,String> exportMap = new LinkedHashMap<>();
            exportMap.put("assessmentContent","考核内容");
            exportMap.put("weight","权重");
            exportMap.put("assessmentDetailedContent","详细考核内容");
            exportMap.put("scoringCriteria","评分标准");
            exportMap.put("checkSituation","检查情况");
            exportMap.put("score","得分");
            exportMap.put("remarks","备注");
            setSheetData(excel, exportMap, list, 3, 1);
        }
        return excel.getWorkBook();
    }


    public void setSheetTitle(Excel excel, String title){
        excel.row().height(35);
        excel.cell(0, 0).value("").border(BorderStyle.THIN, Color.BLACK) // 设置外边框样式
                .fontHeightInPoint(25).warpText(true).align(Align.LEFT).height(35); // 设置水平对齐方式
        excel.cell(0, 0).value(title).align(Align.CENTER).height(35) // 设置水平对齐方式
                .bgColor(Color.GREY_25_PERCENT) // 设置背景色
                .fontHeightInPoint(28).width(256 * 20)// 增加宽度
                .border(BorderStyle.THIN, Color.BLACK) // 设置外边框样式
                .font(new IFontEditor() { // 设置字体
                    @Override
                    public void updateFont(Font font) {
                        font.boldweight(BoldWeight.BOLD);// 粗体
                        font.color(Color.BLACK);// 字体颜色
                    }
                });

    }

    public void setSheetCell(Excel excel, int row, int col, Object obj){
        String val = obj == null ? "" : String.valueOf(obj);
//        excel.cell(row, col).value(val).border(BorderStyle.THIN, Color.BLACK) // 设置外边框样式
//                .fontHeightInPoint(14).warpText(true).align(Align.LEFT); // 设置水平对齐方式
//        excel.row().height(30);
        excel.cell(row, col).value("").border(BorderStyle.THIN, Color.WHITE) // 设置外边框样式
                .fontHeightInPoint(12).warpText(true).align(Align.LEFT).height(30); // 设置水平对齐方式
        excel.cell(row, col).value(val).align(Align.CENTER).height(30) // 设置水平对齐方式
                .fontHeightInPoint(12).width(256 * 20)// 增加宽度
                .border(BorderStyle.THIN, Color.BLACK) // 设置外边框样式
                .font(new IFontEditor() { // 设置字体
                    @Override
                    public void updateFont(Font font) {
                        font.boldweight(BoldWeight.NORMAL);// 粗体
                        font.color(Color.BLACK);// 字体颜色
                    }
                });
    }


    public void setSheetHeader(Excel excel, Map<String, String> fieldMap, int row, int col){
        int rows = row;
        int cols = col;
        for (String name : fieldMap.values()) { // 表头已经排序过了
            excel.cell(rows, cols).value("").border(BorderStyle.THIN, Color.BLACK) // 设置外边框样式
                    .fontHeightInPoint(12).warpText(true).align(Align.LEFT).height(30); // 设置水平对齐方式
            excel.cell(rows, cols).value(name).align(Align.CENTER).height(30) // 设置水平对齐方式
                    .fontHeightInPoint(12).width(256 * 20)// 增加宽度
                    .border(BorderStyle.THIN, Color.BLACK) // 设置外边框样式
                    .font(new IFontEditor() { // 设置字体
                        @Override
                        public void updateFont(Font font) {
                            font.boldweight(BoldWeight.BOLD);// 粗体
                            font.color(Color.BLACK);// 字体颜色
                        }
                    });
            cols++;
        }
    }

    public void setSheetData(Excel excel, Map<String, String> fieldMap, List data,int headerRowIndex, int headerColIndex){
        int size = fieldMap.size();
        int rows = headerRowIndex;
        int cols = headerColIndex;
        // 设置表头，第指定行和列开始
        excel.cell(rows, 0).value("").border(BorderStyle.THIN, Color.BLACK) // 设置外边框样式
                .fontHeightInPoint(12).warpText(true).align(Align.LEFT).height(30); // 设置水平对齐方式
        excel.cell(rows, 0).value("序号").align(Align.CENTER).height(30) // 设置水平对齐方式
                .fontHeightInPoint(12).width(256 * 20)// 增加宽度
                .border(BorderStyle.THIN, Color.BLACK) // 设置外边框样式
                .font(new IFontEditor() { // 设置字体
                    @Override
                    public void updateFont(Font font) {
                        font.boldweight(BoldWeight.BOLD);// 粗体
                        font.color(Color.BLACK);// 字体颜色
                    }
                });
        for (String name : fieldMap.values()) { // 表头已经排序过了
            excel.cell(rows, cols).value("").border(BorderStyle.THIN, Color.BLACK) // 设置外边框样式
                    .fontHeightInPoint(12).warpText(true).align(Align.LEFT).height(30); // 设置水平对齐方式
            excel.cell(rows, cols).value(name).align(Align.CENTER).height(30) // 设置水平对齐方式
                    .fontHeightInPoint(12).width(256 * 20)// 增加宽度
                    .border(BorderStyle.THIN, Color.BLACK) // 设置外边框样式
                    .font(new IFontEditor() { // 设置字体
                        @Override
                        public void updateFont(Font font) {
                            font.boldweight(BoldWeight.BOLD);// 粗体
                            font.color(Color.BLACK);// 字体颜色
                        }
                    });
            cols++;
        }
        // 插入数据，从指定列+1开始
        int datarows = rows+1;
        int sequence = 1;
        for (Object obj : data) {
            Map rowObj = (Map) obj;
            int datacol = 1;
            excel.cell(datarows, 0).value(sequence).border(BorderStyle.THIN, Color.BLACK) // 设置外边框样式
                    .fontHeightInPoint(12).warpText(true).align(Align.CENTER).height(30); // 设置水平对齐方式
            for (String key : fieldMap.keySet()) {
                String val = rowObj.get(key) == null ? "" : rowObj.get(key).toString();
                excel.cell(datarows, datacol).value(val).border(BorderStyle.THIN, Color.BLACK) // 设置外边框样式
                        .fontHeightInPoint(12).warpText(true).align(Align.LEFT).height(30); // 设置水平对齐方式
                datacol++;
            }
            datarows++;
            sequence++;
        }

    }


    public int setSheetDataNoHeader (Excel excel, Map<String, String> fieldMap, List data,int headerRowIndex, int headerColIndex){
        if(data == null) return headerRowIndex;
        // 插入数据
        int datarows = headerRowIndex;
        for (Object obj : data) {
            Map rowObj = (Map) obj;
            int datacol = headerColIndex;
            for (String key : fieldMap.keySet()) {
                String val = rowObj.get(key) == null ? "" : rowObj.get(key).toString();
                excel.cell(datarows, datacol).value(val).border(BorderStyle.THIN, Color.BLACK) // 设置外边框样式
                        .fontHeightInPoint(12).warpText(true).align(Align.LEFT).height(30); // 设置水平对齐方式
                datacol++;
            }
            datarows++;
        }
        return datarows;
    }


}
