/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.businessdata.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.JsonUtil;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.artfess.uc.params.org.OrgVo;
import com.artfess.yhxt.basedata.dao.RoadDao;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.businessdata.dao.CompanyDao;
import com.artfess.yhxt.businessdata.manager.CompanyManager;
import com.artfess.yhxt.businessdata.model.Company;
import com.artfess.yhxt.businessdata.vo.CompanyVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CompanyManagerImpl
extends BaseManagerImpl<CompanyDao, Company>
implements CompanyManager {
    @Resource
    OrgManager orgManager;
    @Resource
    OrgDao orgDao;
    @Resource
    BaseContext baseContext;
    @Resource
    RoadDao roadDao;

    @Override
    public PageList<Company> queryCompany(QueryFilter<Company> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<Company> result = ((CompanyDao)this.baseMapper).getCompany((IPage<Company>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Company>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void removeCompanyByIds(List<String> list, String code) throws Exception {
        this.orgManager.deleteOrg(code);
        this.removeByIds(list);
    }

    @Override
    @Transactional
    public void saveCompany(Company company) throws Exception {
        OrgVo orgVo = new OrgVo();
        orgVo.setName(company.getName());
        orgVo.setCode(company.getCode());
        orgVo.setParentId(company.getParentId());
        orgVo.setGrade(company.getGrade());
        orgVo.setOrgKind(company.getOrgKind());
        orgVo.setDemId(company.getDemId());
        orgVo.setOrderNo(company.getOrderNo());
        orgVo.setLimitNum(company.getLimitNum());
        orgVo.setNowNum(company.getNowNum());
        orgVo.setExceedLimitNum(company.getExceedLimitNum());
        CommonResult result = this.orgManager.addOrg(orgVo);
        Map map = JsonUtil.toMap((String)((String)result.getValue()));
        company.setId(map.get("id").toString());
        company.setPath(map.get("path").toString());
        company.setPathName(map.get("pathName").toString());
        this.create((Model)company);
    }

    @Override
    @Transactional
    public void updateCompany(Company company) throws Exception {
        OrgVo orgVo = new OrgVo();
        orgVo.setName(company.getName());
        orgVo.setCode(company.getCode());
        orgVo.setParentId(company.getParentId());
        orgVo.setGrade(company.getGrade());
        orgVo.setOrgKind(company.getOrgKind());
        orgVo.setDemId(company.getDemId());
        orgVo.setOrderNo(company.getOrderNo());
        orgVo.setLimitNum(company.getLimitNum());
        orgVo.setNowNum(company.getNowNum());
        orgVo.setExceedLimitNum(company.getExceedLimitNum());
        CommonResult result = this.orgManager.updateOrg(orgVo);
        Map map = JsonUtil.toMap((String)((String)result.getValue()));
        company.setPath(map.get("path").toString());
        company.setPathName(map.get("pathName").toString());
        this.update((Model)company);
    }

    @Override
    public List<CompanyVo> getTree(String demId, List<String> grades) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)demId), (Object)"DEM_ID_", (Object)demId);
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        List orgs = this.orgDao.selectList((Wrapper)queryWrapper);
        ArrayList<CompanyVo> vos = new ArrayList<CompanyVo>();
        ArrayList<CompanyVo> rootMenu = new ArrayList<CompanyVo>();
        for (Org org : orgs) {
            CompanyVo vo = new CompanyVo();
            vo.setCode(org.getCode());
            vo.setId(org.getId());
            vo.setName(org.getName());
            vo.setParentId(org.getParentId());
            vo.setCode(org.getCode());
            vo.setGrade(org.getGrade());
            vo.setOrgKind(org.getOrgKind());
            vo.setDemId(org.getDemId());
            vo.setOrderNo(org.getOrderNo());
            vo.setPath(org.getPath());
            vo.setPathName(org.getPathName());
            if (grades != null && grades.size() > 0 && StringUtils.isNotBlank((CharSequence)org.getGrade()) && grades.contains(org.getGrade())) {
                vo.setDisabled(true);
            } else {
                vo.setDisabled(false);
            }
            vos.add(vo);
        }
        for (CompanyVo vo : vos) {
            if (!"0".equals(vo.getParentId())) continue;
            rootMenu.add(vo);
        }
        for (CompanyVo menu : rootMenu) {
            List<CompanyVo> child = this.getChild(menu.getId(), vos);
            menu.setChildren(child);
        }
        return rootMenu;
    }

    @Override
    public List<Org> getCompany(QueryFilter queryFilter) {
        List orgs;
        QueryWrapper orgQueryWrapper = new QueryWrapper();
        String currentOrgId = this.baseContext.getCurrentOrgId();
        Org org = (Org)this.orgManager.getById((Serializable)((Object)currentOrgId));
        ArrayList<Org> orgList = new ArrayList<Org>();
        if (StringUtils.isEmpty((CharSequence)currentOrgId)) {
            orgQueryWrapper.eq((Object)"grade_", (Object)"1");
            orgQueryWrapper.eq((Object)"parent_id_", (Object)"0");
            orgQueryWrapper.eq((Object)"is_dele_", (Object)0);
            orgQueryWrapper.eq((Object)"org_kind_", (Object)"ogn");
            List o = this.orgManager.getBaseMapper().selectList((Wrapper)orgQueryWrapper);
            String id = ((Org)o.get(0)).getId();
            orgList.addAll(((CompanyDao)this.baseMapper).getOrgsByparentId(id));
        }
        if (org != null && org.getGrade().equals("1") && org.getOrgKind().equals("ogn")) {
            String id = org.getId();
            orgs = ((CompanyDao)this.baseMapper).getOrgsByparentId(id);
            orgList.addAll(orgs);
        }
        if (org != null && org.getGrade().equals("2") && org.getOrgKind().equals("ogn")) {
            orgQueryWrapper.eq((Object)"ID_", (Object)org.getId());
            orgs = this.orgManager.getBaseMapper().selectList((Wrapper)orgQueryWrapper);
            orgList.addAll(orgs);
        }
        return orgList;
    }

    @Override
    public List<CompanyVo> getTreeNewCompany(String demId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)demId), (Object)"DEM_ID_", (Object)demId);
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        queryWrapper.eq((Object)"ORG_KIND_", (Object)"ogn");
        queryWrapper.like((Object)"CODE_", (Object)"10");
        List orgs = this.orgDao.selectList((Wrapper)queryWrapper);
        ArrayList<CompanyVo> vos = new ArrayList<CompanyVo>();
        ArrayList<CompanyVo> rootMenu = new ArrayList<CompanyVo>();
        for (Org org : orgs) {
            CompanyVo vo = new CompanyVo();
            vo.setCode(org.getCode());
            vo.setId(org.getId());
            vo.setName(org.getName());
            vo.setParentId(org.getParentId());
            vo.setCode(org.getCode());
            vo.setGrade(org.getGrade());
            vo.setOrgKind(org.getOrgKind());
            vo.setDemId(org.getDemId());
            vo.setOrderNo(org.getOrderNo());
            vo.setPath(org.getPath());
            vo.setPathName(org.getPathName());
            vo.setDisabled(false);
            if (org != null && org.getGrade().equals("3") && org.getOrgKind().equals("ogn")) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.eq((Object)"COMPANY_ID", (Object)org.getId());
                for (Road road : this.roadDao.selectList((Wrapper)roadQueryWrapper)) {
                    CompanyVo roadVo = new CompanyVo();
                    roadVo.setParentId(org.getId());
                    roadVo.setCode(road.getCode());
                    roadVo.setId(road.getId());
                    roadVo.setName(road.getName());
                    roadVo.setCode(road.getCode());
                    vos.add(roadVo);
                }
            }
            vos.add(vo);
        }
        for (CompanyVo vo : vos) {
            if (!"0".equals(vo.getParentId())) continue;
            rootMenu.add(vo);
        }
        for (CompanyVo menu : rootMenu) {
            List<CompanyVo> child = this.getChild(menu.getId(), vos);
            menu.setChildren(child);
        }
        return rootMenu;
    }

    @Override
    public List<CompanyVo> getTreeCompany(String demId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)demId), (Object)"DEM_ID_", (Object)demId);
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        queryWrapper.eq((Object)"ORG_KIND_", (Object)"ogn");
        queryWrapper.like((Object)"CODE_", (Object)"10");
        List orgs = this.orgDao.selectList((Wrapper)queryWrapper);
        ArrayList<CompanyVo> vos = new ArrayList<CompanyVo>();
        ArrayList<CompanyVo> rootMenu = new ArrayList<CompanyVo>();
        for (Org org : orgs) {
            CompanyVo vo = new CompanyVo();
            vo.setCode(org.getCode());
            vo.setId(org.getId());
            vo.setName(org.getName());
            vo.setParentId(org.getParentId());
            vo.setCode(org.getCode());
            vo.setGrade(org.getGrade());
            vo.setOrgKind(org.getOrgKind());
            vo.setDemId(org.getDemId());
            vo.setOrderNo(org.getOrderNo());
            vo.setPath(org.getPath());
            vo.setPathName(org.getPathName());
            vo.setDisabled(false);
            vos.add(vo);
        }
        for (CompanyVo vo : vos) {
            if (!"0".equals(vo.getParentId())) continue;
            rootMenu.add(vo);
        }
        for (CompanyVo menu : rootMenu) {
            List<CompanyVo> child = this.getChild(menu.getId(), vos);
            menu.setChildren(child);
        }
        return rootMenu;
    }

    public List<Org> getCompany() {
        QueryWrapper orgQueryWrapper = new QueryWrapper();
        String currentOrgId = this.baseContext.getCurrentOrgId();
        Org org = (Org)this.orgManager.getById((Serializable)((Object)currentOrgId));
        List<Object> orgs = new ArrayList<Org>();
        if (StringUtils.isEmpty((CharSequence)currentOrgId)) {
            orgQueryWrapper.eq((Object)"grade_", (Object)"1");
            orgQueryWrapper.eq((Object)"parent_id_", (Object)"0");
            orgQueryWrapper.eq((Object)"is_dele_", (Object)0);
            List orgList = this.orgManager.getBaseMapper().selectList((Wrapper)orgQueryWrapper);
            String id = ((Org)orgList.get(0)).getId();
            orgs = this.orgManager.getOrgsByparentId(id);
        }
        if (org != null && org.getGrade().equals("1") && org.getOrgKind().equals("ogn")) {
            String id = org.getId();
            orgs = this.orgManager.getOrgsByparentId(id);
        }
        if (org != null && org.getGrade().equals("2") && org.getOrgKind().equals("ogn")) {
            orgQueryWrapper.eq((Object)"ID_", (Object)org.getId());
            orgs = this.orgManager.getBaseMapper().selectList((Wrapper)orgQueryWrapper);
        }
        return orgs;
    }

    private List<CompanyVo> getChild(String id, List<CompanyVo> vos) {
        ArrayList<CompanyVo> childrens = new ArrayList<CompanyVo>();
        for (CompanyVo vo : vos) {
            if (!vo.getParentId().equals(id)) continue;
            childrens.add(vo);
        }
        for (CompanyVo vo : childrens) {
            List<CompanyVo> child = this.getChild(vo.getId(), vos);
            if (child.size() <= 0) continue;
            vo.setChildren(child);
        }
        if (childrens.size() == 0) {
            return new ArrayList<CompanyVo>();
        }
        return childrens;
    }
}

