package com.artfess.table.factory;

import com.artfess.base.constants.SQLConst;
import com.artfess.table.operator.ITableOperator;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.annotation.Resource;

/**
 * TableOperator factorybean，用户创建ITableOperator对象
 *
 * @author heyifan
 * @company 广州宏天软件股份有限公司
 * @email heyf@jee-soft.cn
 * @date 2018年4月25日
 */
public class TableOperatorFactoryBean implements FactoryBean<ITableOperator> {
    // 表操作
    private ITableOperator tableOperator;
    // 数据库类型
    private String dbType = SQLConst.DB_MYSQL;
    @Resource
    private JdbcTemplate jdbcTemplate;

    @Override
    public ITableOperator getObject() throws Exception {
        tableOperator = DatabaseFactory.getTableOperator(dbType);
        tableOperator.setJdbcTemplate(jdbcTemplate);
        return tableOperator;
    }

    /**
     * 设置数据库类型
     *
     * @param dbType
     */
    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    @Override
    public Class<?> getObjectType() {
        return ITableOperator.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}
