package com.artfess.file.attachmentService;

import com.artfess.base.attachment.Attachment;
import com.artfess.base.attachment.AttachmentService;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.config.AliyunOssSettings;
import com.artfess.file.config.MinioSetting;
import com.artfess.file.model.FileStorage;
import com.artfess.file.params.FlowUploadPropertiesStorageDTO;
import com.artfess.file.persistence.manager.FileStorageManager;
import com.artfess.file.persistence.manager.FlowUploadPropertiesManager;
import com.artfess.file.util.MinioUtil;
import org.springframework.stereotype.Service;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;

@Service
public class MinioAttachmentServiceImpl implements AttachmentService {

    public MinioAttachmentServiceImpl(){}

    @Override
    public String getStoreType() {
        return "minio";
    }

    private MinioSetting initMinioSettings(Attachment attachment, String propertiesId) {
        MinioSetting ossSettings = AppUtil.getBean(MinioSetting.class);
        if (StringUtil.isNotEmpty(propertiesId)) {
            FileStorageManager fileStorageManager = AppUtil.getBean(FileStorageManager.class);
            FileStorage fileStorage = fileStorageManager.get(propertiesId);
            if (BeanUtils.isNotEmpty(fileStorage)) {
                ossSettings.setMinioName(fileStorage.getUserName());
                ossSettings.setMinioPass(fileStorage.getPassword());
                String minioUrl =fileStorage.getUrl();
                if(!minioUrl.startsWith("http")){
                    minioUrl = "http://" + minioUrl;
                }
                if(!minioUrl.endsWith("/")){
                    minioUrl = minioUrl.concat("/");
                }
                ossSettings.setMinioUrl(minioUrl);
                ossSettings.setBucketName(fileStorage.getLocation());
                attachment.setEntryptName(fileStorage.getEncryptName() == 0 ? false : true);
            }else{
                FlowUploadPropertiesManager uploadPropertiesManager = AppUtil.getBean(FlowUploadPropertiesManager.class);
                FlowUploadPropertiesStorageDTO uploadProperties = uploadPropertiesManager.getById(propertiesId);
                if (BeanUtils.isNotEmpty(uploadProperties)) {
                    ossSettings.setMinioName(uploadProperties.getUserName());
                    ossSettings.setMinioPass(uploadProperties.getPassword());
                    String minioUrl =uploadProperties.getUrl();
                    if(!minioUrl.startsWith("http")){
                        minioUrl = "http://" + minioUrl;
                    }
                    if(!minioUrl.endsWith("/")){
                        minioUrl = minioUrl.concat("/");
                    }
                    ossSettings.setMinioUrl(minioUrl);
                    ossSettings.setBucketName(uploadProperties.getLocation());
                    attachment.setEntryptName(uploadProperties.getEncryptName() == 0 ? false : true);
                }
            }
        }
        MinioUtil.setMinioUrl(ossSettings.getMinioUrl());
        MinioUtil.setMinioName(ossSettings.getMinioName());
        MinioUtil.setMinioPass(ossSettings.getMinioPass());
        MinioUtil.setBucketName(ossSettings.getBucketName());
        return ossSettings;
    }

    @Override
    public void remove(Attachment attachment, String propertiesId) throws Exception {
        String filePath = getFilePath(attachment);
        initMinioSettings(attachment,propertiesId);
        MinioUtil.removeObject(filePath,true);
    }

    @Override
    public void upload(Attachment attachment, InputStream inputStream, String propertiesId) throws Exception {
        String filePath = getFilePath(attachment);
        initMinioSettings(attachment,propertiesId);
        MinioUtil.uploadByInputStream(inputStream,filePath);
    }

    @Override
    public void download(Attachment attachment, OutputStream outStream, String propertiesId) throws Exception {
        String filePath = getFilePath(attachment);
        initMinioSettings(attachment,propertiesId);
        MinioUtil.downFile("",filePath,outStream,true);
    }

    @Override
    public boolean chekckFile(Attachment attachment, String propertiesId) throws Exception {
        initMinioSettings(attachment,propertiesId);
        return MinioUtil.checkFile("",attachment.getFileName(),true);
    }

    @Override
    public byte[] getFileBytes(Attachment sysFile) throws Exception {
        return new byte[0];
    }
    /**
    * @Description: 获取文件相对路径
    * @param attachment  附件信息
    * @Return: 文件相对路径
    * @Author: llj
    * @Date: 2021/3/23 11:36
    */
    public String getFilePath(Attachment attachment){
        String fileParentPath = "";
        String filePath = attachment.getFilePath();
        if (StringUtil.isNotEmpty(filePath)) {
            fileParentPath = Paths.get(filePath).getParent().toString();
            fileParentPath = fileParentPath.replaceAll("\\\\", "/");
            if (fileParentPath.startsWith("/")) {
                fileParentPath = fileParentPath.substring(1);
            }
        }
        String file =fileParentPath+ "/"+attachment.getId()+"."+attachment.getExtensionName();
        return file;
    }
}
