package com.artfess.form.persistence.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.form.model.ComponentValidEntity;
import com.artfess.form.persistence.dao.ComponentValidDao;
import com.artfess.form.persistence.manager.ComponentValidManager;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * @program: cqgs
 * @Date: 2020/9/26 17:13
 * @Author: ZQF
 * @Description: 元件管理-数据有效性校验配置
 */
@Service
public class ComponentValidServiceImpl extends BaseManagerImpl<ComponentValidDao, ComponentValidEntity> implements ComponentValidManager {

    @Autowired
    ComponentValidManager componentValidMapper;


    @Override
    @Transactional
    public String insertComponentValid(ComponentValidEntity componentValidEntity) {
        Assert.notNull(componentValidEntity, "参数为空，请检查后尝试！");
        //获取排序号
        Integer nextSequence = this.getNextSequence(null);
        componentValidEntity.setSn(nextSequence);
        //数据合法性验证
        checkValidity(componentValidEntity);
        this.componentValidMapper.save(componentValidEntity);
        return componentValidEntity.getId();
    }

    @Override
    @Transactional
    public String updateComponentValid(ComponentValidEntity componentValidEntity) {
        Assert.notNull(componentValidEntity, "参数为空，请检查后尝试！");
        //数据合法性验证
        checkValidity(componentValidEntity);
        this.componentValidMapper.updateById(componentValidEntity);
        return componentValidEntity.getId();
    }

    @Override
    public ComponentValidEntity loadComponentValid(String id) {
        Assert.hasText(id, "参数id为空，请检查后尝试！");
        return this.getById(id);
    }

    @Override
    @Transactional
    public Integer deleteComponentValid(String ids) {
        Assert.hasText(ids, "参数ids为空，请检查后尝试！");
        List<String> idsList = Arrays.asList(ids.split(","));
        this.componentValidMapper.removeByIds(idsList);
        return 1;
    }

    @Override
    public List<ComponentValidEntity> queryComponentValid(ComponentValidEntity componentValidEntity) {
        QueryWrapper<ComponentValidEntity> queryWrapper= new QueryWrapper<>();
        //查询条件
        queryWrapper.like(StringUtils.isNotBlank(componentValidEntity.getValidName()), "VALID_NAME", componentValidEntity.getValidName());
        queryWrapper.eq(Objects.nonNull(componentValidEntity.getValidMode()), "VALID_MODE", componentValidEntity.getValidMode());
        //queryWrapper.eq(Objects.nonNull(componentValidEntity.getFlag()), "FLAG", componentValidEntity.getFlag());
        //排序规则
        queryWrapper.orderByAsc("SEQUENCE");
        return this.componentValidMapper.list(queryWrapper);
    }

//    @Override
//    public Page<ComponentValidEntity> slicedQueryComponentValid(BasePage<ComponentValidEntity> pageRequest) {
//        QueryWrapper<ComponentValidEntity> queryWrapper= new QueryWrapper<>();
//        //查询条件
//        queryWrapper.like(StringUtils.isNotBlank(pageRequest.getParam().getValidName()), "VALID_NAME", pageRequest.getParam().getValidName());
//        queryWrapper.eq(Objects.nonNull(pageRequest.getParam().getValidMode()), "VALID_MODE", pageRequest.getParam().getValidMode());
//        queryWrapper.eq(Objects.nonNull(pageRequest.getParam().getFlag()), "FLAG", pageRequest.getParam().getFlag());
//        //分页查询排序规则
//        pageRequest.getOrders().forEach(s -> queryWrapper.orderBy(StringUtils.isNotBlank(s.getColumn()), s.isAsc(), s.getColumn()));
//        IPage<ComponentValidEntity> pages = this.componentValidMapper.selectPage(pageRequest, queryWrapper);
//        Page<ComponentValidEntity> page = new Page<>(pageRequest.getCurrent(), pageRequest.getSize());
//        page.setRecords(pages.getRecords());
//        if (pageRequest.isSearchCount()) {
//            page.setTotal(pages.getTotal());
//        }
//        return page;
//    }

    @Override
    public void updateComponentValidStatus(String ids, Integer status) {
        List<String> idsList = Arrays.asList(ids.split(","));
        //this.updateEntityFlags(idsList, status);
    }

    /**
     * @Description: 数据合法性校验
     * @param componentValidEntity
     * @Return: void
     * @Author: ZQF
     * @Date: 2020/9/27 9:40
     */
    private void checkValidity(ComponentValidEntity componentValidEntity) {
        //名称不重复
        QueryWrapper<ComponentValidEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(StringUtils.isNotBlank(componentValidEntity.getValidName()), "VALID_NAME", componentValidEntity.getValidName());
        queryWrapper.ne(StringUtils.isNotBlank(componentValidEntity.getId()), "ID", componentValidEntity.getId());
        Integer count = this.componentValidMapper.count(queryWrapper);
        if (count > 0) {
            throw new ApplicationException("名称已存在，请检查后尝试！");
        }
    }

}
