package com.artfess.cqxy.feasiblePlan.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 规划许可-选址表(BizPlanningSelectionSite)表实体类
 * @author 黎沐华
 * @since 2022-02-15 09:32:24
 */
@Data
@TableName("BIZ_PLANNING_SELECTION_SITE")
@ApiModel(value="可研规划-规划许可-选址对象-PlanningSelectionSite", description="规划许可-选址表")
public class PlanningSelectionSite extends BizModel<PlanningSelectionSite> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

//    @Excel(name = "名称")
    @TableField("ESTABLISHMENT_NAME_")
    @ApiModelProperty(value = "名称")
    private String establishmentName;

//    @Excel(name = "文号")
    @TableField("DOCUMENT_NUMBER_")
    @ApiModelProperty(value = "文号")
    private String documentNumber;

    @Excel(name = "核发机关")
    @TableField("ESTABLISHMENT_APPROVAL_UNIT_")
    @ApiModelProperty(value = "核发机关")
    private String establishmentApprovalUnit;

    @Excel(name = "核发日期",format = "yyyy-MM-dd")
    @TableField("ESTABLISHMENT_DATE_")
    @ApiModelProperty(value = "核发日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date establishmentDate;

    @Excel(name = "拟建设规模")
    @TableField("ESTABLISHMENT_SCALE_")
    @ApiModelProperty(value = "拟建设规模")
    private String establishmentScale;

    @Excel(name = "拟用地面积(m²)")
    @TableField("PROPOSED_LAND_AREA_")
    @ApiModelProperty(value = "拟用地面积(平方米)")
    private String proposedLandArea;

    @Excel(name = "拟选位置")
    @TableField("PROPOSED_LOCATION_")
    @ApiModelProperty(value = "拟选位置")
    private String proposedLocation;

    @Excel(name = "备注")
    @TableField("ESTABLISHMENT_REMARKS_")
    @ApiModelProperty(value = "备注")
    private String establishmentRemarks;

//    @Excel(name = "建设单位名称")
    @TableField("CONSTRUCTION_UNIT_")
    @ApiModelProperty(value = "建设单位名称")
    private String constructionUnit;

//    @Excel(name = "建设项目依据")
    @TableField("CONSTRUCTION_PROJECT_BASIS_")
    @ApiModelProperty(value = "建设项目依据")
    private String constructionProjectBasis;

//    @Excel(name = "建设长度")
    @TableField("CONSTRUCTION_LENGTH_")
    @ApiModelProperty(value = "建设长度")
    private String constructionLength;

//    @Excel(name = "建设宽度")
    @TableField("CONSTRUCTION_WIDTH_")
    @ApiModelProperty(value = "建设宽度")
    private String constructionWidth;

//    @Excel(name = "建设高度")
    @TableField("CONSTRUCTION_HEIGHT_")
    @ApiModelProperty(value = "建设高度")
    private String constructionHeight;

//    @Excel(name = "主要内容")
    @TableField("PRIMARY_COVERAGE_")
    @ApiModelProperty(value = "主要内容")
    private String primaryCoverage;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "PlanningSelectionSite{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", establishmentName='" + establishmentName + '\'' +
                ", documentNumber='" + documentNumber + '\'' +
                ", establishmentDate=" + establishmentDate +
                ", establishmentApprovalUnit='" + establishmentApprovalUnit + '\'' +
                ", constructionUnit='" + constructionUnit + '\'' +
                ", constructionProjectBasis='" + constructionProjectBasis + '\'' +
                ", proposedLocation='" + proposedLocation + '\'' +
                ", proposedLandArea='" + proposedLandArea + '\'' +
                ", establishmentScale='" + establishmentScale + '\'' +
                ", constructionLength='" + constructionLength + '\'' +
                ", constructionWidth='" + constructionWidth + '\'' +
                ", constructionHeight='" + constructionHeight + '\'' +
                ", primaryCoverage='" + primaryCoverage + '\'' +
                ", establishmentRemarks='" + establishmentRemarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }

}

