package com.artfess.cqxy.warranty.entity;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 质量保修(Warranty)表实体类
 *
 * @author 黎沐华
 * @since 2022-06-01 15:00:58
 */
@Data
@TableName("biz_warranty")
@ApiModel(value="竣工验收-质量保修对象-Warranty", description="质量保修表")
public class Warranty extends BizModel<Warranty> {

    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID")
    private String projectId;

    @TableField("PROJECT_NAME_")
    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @Excel(name = "质量保修名称")
    @TableField("NAME_")
    @ApiModelProperty(value = "质量保修名称")
    private String name;

    @Excel(name = "竣工验收时间",format = "yyyy-MM-dd")
    @TableField("FINISH_TIME_")
    @ApiModelProperty(value = "竣工验收日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishTime;

    @Excel(name = "保修期")
    @TableField("WARRANTY_TIME")
    @ApiModelProperty(value = "保修期")
    private String warrantyTime;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

}

