package com.artfess.cqxy.completionAcceptance.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DateUtils;
import com.artfess.cqxy.completionAcceptance.dao.RecordAcceptanceDao;
import com.artfess.cqxy.completionAcceptance.manager.RecordAcceptanceManager;
import com.artfess.cqxy.completionAcceptance.model.RecordAcceptance;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 竣工验收 - 联合备案验收表(BizRecordAcceptance)表服务实现类
 *
 * @author 黎沐华
 * @since 2022-03-07 14:28:02
 */
@Service
public class RecordAcceptanceManagerImpl extends BaseManagerImpl<RecordAcceptanceDao, RecordAcceptance> implements RecordAcceptanceManager {

    @Autowired
    private AccessoryManager accessoryManager;

    @Autowired
    private ProjectManagementManager pm;

    @Autowired
    private BaseContext baseContext;

    @Autowired
    private GlobalRetrievalManager grm;

    @Override
    public boolean saveOrUpdate(RecordAcceptance entity) {
        boolean save = StringUtils.isEmpty(entity.getId());
        boolean savedMain = super.saveOrUpdate(entity);
        // 处理附件信息
        List<Accessory> flag = entity.getAccessoryInfo();//处理空指针
        List<Accessory> accessoryList = null == flag ? new ArrayList<>():flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.ten.getCode());
            ele.setGroup("RecordAcceptance");
            ele.setNode(ProjectStatusEnum.ten.getCode());
            ele.setCreateBy(baseContext.getCurrentUserId());
            ele.setCreateName(baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        // 先清空该ID下的所有附件信息再添加
        accessoryManager.removeBySourceId(entity.getId());
        // 如果没有附件则返回true，不进入添加
        boolean saveAcc = accessoryList.size() == 0 || accessoryManager.saveAccess(accessoryList);
        //更新项目状态
        pm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.twelve.getCode()));
        // 同步开竣工时间
        ProjectManagement projectManagement = pm.getById(entity.getProjectId());
        if(null != projectManagement){
            //完工时间
//            if(null == projectManagement.getCompletionTime()){
//                projectManagement.setCompletionTime(entity.getCompletionAcceptanceDate());
//            }
            //竣工验收时间
            if(null != entity.getCompletionAcceptanceDate()){
                projectManagement.setCompletionAcceptanceTime(entity.getCompletionAcceptanceDate());
                pm.updateById(projectManagement);
            }
        }
        // 同步到检索表
        GlobalRetrieval globalRetrieval= grm.getByBizId(entity.getId());
        handleRetrieval(save || BeanUtils.isEmpty(globalRetrieval) ?new GlobalRetrieval():globalRetrieval,entity);

        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval,RecordAcceptance entity){
        ProjectManagement projectManagement = pm.getById(entity.getProjectId());
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.twentyFour.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.twentyFour.getName());
        globalRetrieval.setBizTableName(FunctionEnum.twentyFour.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.twentyFour.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.twentyFour.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.twentyFour.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.twentyFour.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.twentyFour.getFunctionPath());
        globalRetrieval.setDocumentNumber(entity.getDocumentNumber());
        globalRetrieval.setName(entity.getName());
        globalRetrieval.setSearchTitle(entity.getName()+"_"+entity.getDocumentNumber()+"_"+entity.getCompletionAcceptanceOpinions()+"_"+
                entity.getCompletionProjectName()+"_"+entity.getCompletionAcceptanceRegistrant()+"_"+entity.getApprovalFilingAuthority()
                +"_"+entity.getApprovalUnitFilingAuthority() +"_"+entity.getApprovalOpinion() +"_"+entity.getRemarks());
        grm.saveOrUpdate(globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        // 同步删除检索表中的信息
        for(String ele:ids){
            grm.remove(1,ele);
        }
        return removeByIds(ids);
    }

    @Override
    public RecordAcceptance getById(String id) {
        return baseMapper.getById(id);
    }

    @Override
    public PageList<RecordAcceptance> queryAllByPage(QueryFilter<RecordAcceptance> queryFilter) {
        BizUtils.handleFilter(queryFilter,"bra" ,false);
        IPage<RecordAcceptance> result =
                baseMapper.queryAllByPage(
                        convert2IPage(queryFilter.getPageBean()),
                        convert2Wrapper(queryFilter, currentModelClass()));
        // 附件信息处理
        List<RecordAcceptance> records = result.getRecords();
        for (RecordAcceptance ele: records ) {
            ele.setAccessoryInfo(accessoryManager.getAccessoryBySourceId(ele.getId()));
        }

        return new PageList<>(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        Assert.notNull(projectId,"项目ID不能为空");
        String projectName = pm.get(projectId).getProjectName();
        try(InputStream inputStream = file.getInputStream();) {
            // 获取数据
            List<RecordAcceptance> data = ExcelImportUtil.importExcel(inputStream,RecordAcceptance.class,new ImportParams());
            for(RecordAcceptance ele:data){
                ele.setProjectId(projectId);
                ele.setCompletionProjectName(projectName);
                // 保存数据 & 同步到检索表
                save(ele);
                handleRetrieval(new GlobalRetrieval(),ele);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDatatoExcel(QueryFilter<RecordAcceptance> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "竣工验收-联合备案验收-导出结果";

        // 创建excel工作薄
        HSSFWorkbook workbook = new HSSFWorkbook();
        // 创建excel表
        HSSFSheet sheet = workbook.createSheet(fileName);

        // 标题行
        // 拼接标题行数据
        List<String> heards = new ArrayList<>();
        // 注意：Arrays.asList 将会返回一个不可修改的List，不能在初始化时调用
        heards.addAll(Arrays.asList(new String[]{"项目名称","竣工验收日期","备案机关审批单位","备案机关审批日期","竣工验收意见","竣工验收备案登记人","备注" }));

        // 创建标题行并写入数据
        HSSFRow titleRow1 = sheet.createRow(0);
        for (int i = 0; i < heards.size(); i++) {
            BizUtils.handelCell(workbook,fileName, titleRow1.createCell(i), heards.get(i));
        }

        // 数据行,从1行开始,共data.size行
        int row = 1;

        // 获取数据
        BizUtils.handleFilter(queryFilter,"bra" ,false);
        List<RecordAcceptance> data = baseMapper.queryAllByPage(
                        convert2IPage(new PageBean(0,-1,false)),
                        convert2Wrapper(queryFilter, currentModelClass())).
                getRecords();
        if(null==data||data.size()==0){
            throw new RuntimeException("没有要导出的的数据！");
        }

        // 处理数据
        for (int i = 0; i < data.size(); i++) {
            HSSFRow listRow = sheet.createRow(row);// 创建行
            BizUtils.handelCell(workbook,fileName, listRow.createCell(0),data.get(i).getProjectInfo().getProjectName());
            BizUtils.handelCell(workbook,fileName, listRow.createCell(1), DateUtils.date2Str(data.get(i).getCompletionAcceptanceDate(),new SimpleDateFormat("yyyy-MM-dd")));
            BizUtils.handelCell(workbook,fileName, listRow.createCell(2), data.get(i).getApprovalUnitFilingAuthority());
            BizUtils.handelCell(workbook,fileName, listRow.createCell(3), DateUtils.date2Str(data.get(i).getApprovalFilingAuthorityDate(),new SimpleDateFormat("yyyy-MM-dd")));
            BizUtils.handelCell(workbook,fileName, listRow.createCell(4), data.get(i).getCompletionAcceptanceOpinions());
            BizUtils.handelCell(workbook,fileName, listRow.createCell(5), data.get(i).getCompletionAcceptanceRegistrant());
            BizUtils.handelCell(workbook,fileName, listRow.createCell(6), data.get(i).getRemarks());
            row++;
        }

        sheet.setColumnWidth(0,7000);
        ExcelUtil.downloadExcel(workbook, fileName, response);

//        // 获取数据
//        BizUtils.handleFilter(queryFilter,"bra" ,false);
//        List<RecordAcceptance> data = baseMapper.queryAllByPage(
//                        convert2IPage(new PageBean(0,-1,false)),
//                        convert2Wrapper(queryFilter, currentModelClass())).
//                getRecords();
//        if(null==data||data.size()==0){
//            throw new RuntimeException("没有要导出的的数据！");
//        }
//
//        // EasyPoi 导出参数、样式、表格格式设置
//        ExportParams exportParams = BizUtils.getExportParams(fileName);
//        fileName += ".xlsx";
//
//        // 导出下载excel文件
//        Workbook workbook = ExcelExportUtil.exportExcel(exportParams, RecordAcceptance.class, data);
//        ExcelUtil.downloadExcel(workbook, fileName, response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper<RecordAcceptance> wrapper = new UpdateWrapper<RecordAcceptance>()
                .set(StringUtils.isNotBlank(newProjectId), "PROJECT_ID_", newProjectId)
                .in("PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update(wrapper);
    }
}

