package com.artfess.cqxy.designEstimate.model;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 设计概算 - 概算表(BizEstimate)表实体类
 * @author 黎沐华
 * @since 2022-02-15 17:29:48
 */
@Data
@TableName("BIZ_ESTIMATE")
@ApiModel(value="设计概算-概算对象-Estimate", description="概算表")
public class Estimate extends BizModel<Estimate> {
    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

//    @Excel(name = "审核单位")
    @TableField("ESTABLISHMENT_APPROVAL_UNIT_")
    @ApiModelProperty(value = "审核单位")
    private String establishmentApprovalUnit="";

    @Excel(name = "审定概算总投资(万元)", type = 10, numFormat = "0.00")
    @TableField("TOTAL_ESTIMATE_")
    @ApiModelProperty(value = "审定概算总投资(万元)")
    private String totalEstimate;

    @Excel(name = "工程建设其他费用(万元)", type = 10, numFormat = "0.00")
    @TableField("ENGINEERING_OTHER_COST_")
    @ApiModelProperty(value = "工程建设其他费用(万元)")
    private String engineeringOtherCost;

    @Excel(name = "工程费用(万元)", type = 10, numFormat = "0.00")
    @TableField("ENGINEERING_COST_")
    @ApiModelProperty(value = "建安工程费用(万元)")
    private String engineeringCost;

    @Excel(name = "预备费用(万元)", type = 10, numFormat = "0.00")
    @TableField("READY_COST_")
    @ApiModelProperty(value = "预备费用(万元)")
    private String readyCost;

    @Excel(name = "建设期利息(万元)", type = 10, numFormat = "0.00")
    @TableField("ENGINEERING_INTEREST_")
    @ApiModelProperty(value = "建设期贷款利息(万元)")
    private String engineeringInterest;

    @Excel(name = "土地费用(万元)", type = 10, numFormat = "0.00")
    @TableField("DESIGN_SPEED_")
    @ApiModelProperty(value = "土地费用(万元)")
    private String designSpeed;

    @Excel(name = "备注")
    @TableField("ESTABLISHMENT_REMARKS_")
    @ApiModelProperty(value = "备注")
    private String establishmentRemarks;

//    @Excel(name = "编制单位")
    @TableField("NAME_")
    @ApiModelProperty(value = "编制单位")
    private String name;

//    @Excel(name = "文号")
    @TableField("DOCUMENT_NUMBER_")
    @ApiModelProperty(value = "文号")
    private String documentNumber;

//    @Excel(name = "资金来源\n默认：业主自筹")
    @TableField("SOURCE_FUNDS_")
    @ApiModelProperty(value = "资金来源，（默认值：业主自筹）")
    private String sourceFunds;

//    @Excel(name = "审核日期",format = "yyyy-MM-dd")
    @TableField("ESTABLISHMENT_DATE_")
    @ApiModelProperty(value = "审核日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date establishmentDate;

//    @Excel(name = "建设地址")
    @TableField("PROPOSED_LOCATION_")
    @ApiModelProperty(value = "建设地址")
    private String proposedLocation;

//    @Excel(name = "建设长度（单位：m）")
    @TableField("CONSTRUCTION_LENGTH_")
    @ApiModelProperty(value = "建设长度（单位：m）")
    private String constructionLength;

//    @Excel(name = "建设宽度（单位：m）")
    @TableField("CONSTRUCTION_WIDTH_")
    @ApiModelProperty(value = "建设宽度（单位：m）")
    private String constructionWidth;

//    @Excel(name = "工期")
    @TableField("PROJECT_DURATION_")
    @ApiModelProperty(value = "工期（日期格式：2020-06～2020-12）")
    private String projectDuration;

//    @Excel(name = "建设内容及规模")
    @TableField("CONSTRUCTION_SCALE_")
    @ApiModelProperty(value = "建设内容及规模")
    private String constructionScale;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "Estimate{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", name='" + name + '\'' +
                ", documentNumber='" + documentNumber + '\'' +
                ", establishmentApprovalUnit='" + establishmentApprovalUnit + '\'' +
                ", establishmentDate=" + establishmentDate +
                ", proposedLocation='" + proposedLocation + '\'' +
                ", constructionLength='" + constructionLength + '\'' +
                ", constructionWidth='" + constructionWidth + '\'' +
                ", designSpeed='" + designSpeed + '\'' +
                ", engineeringCost='" + engineeringCost + '\'' +
                ", engineeringOtherCost='" + engineeringOtherCost + '\'' +
                ", readyCost='" + readyCost + '\'' +
                ", engineeringInterest='" + engineeringInterest + '\'' +
                ", totalEstimate='" + totalEstimate + '\'' +
                ", sourceFunds='" + sourceFunds + '\'' +
                ", projectDuration='" + projectDuration + '\'' +
                ", constructionScale='" + constructionScale + '\'' +
                ", establishmentRemarks='" + establishmentRemarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }
}

