package com.artfess.cqxy.completionAcceptance.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 竣工验收 -  单位工程验收(UnitProjectAcceptance)表实体类
 *
 * @author 黎沐华
 * @since 2022-04-07 14:23:19
 */
@Data
@TableName("BIZ_UNIT_PROJECT_ACCEPTANCE")
@ApiModel(value="竣工验收-单位工程验收对象-RecordAcceptance", description="单位工程验收表")
public class UnitProjectAcceptance extends BizModel<UnitProjectAcceptance> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @Excel(name = "经办人")
    @TableField("HANDLER_NAME_")
    @ApiModelProperty(value = "经办人（默认项目负责人）")
    private String handlerName;

    @Excel(name = "验收时间",format = "yyyy-MM-dd")
    @TableField("ACCEPTANCE_DATE_")
    @ApiModelProperty(value = "验收时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date acceptanceDate;

    @Excel(name = "验收地点")
    @TableField("ACCEPTANCE_PLACE_")
    @ApiModelProperty(value = "验收地点")
    private String acceptancePlace;

    @Excel(name = "验收主题")
    @TableField("SKETCH_")
    @ApiModelProperty(value = "验收主题")
    private String sketch;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

//    @Excel(name = "参建单位\n默认：西永微电园区")
    @TableField("HANDLER_UNIT_")
    @ApiModelProperty(value = "参建单位（默认西永微电子产业园区开发有限公司）")
    private String handlerUnit;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    public UnitProjectAcceptance() {
        handlerUnit = "西永微电子产业园区开发有限公司";
    }

    /**
     * 获取主键值
     *
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}

