/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.manager.MatrixColDefManager;
import com.artfess.uc.manager.MatrixManager;
import com.artfess.uc.model.Matrix;
import com.artfess.uc.model.MatrixColDef;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/matrix/v1"})
@Api(tags={"matrixController"})
@ApiGroup(group={"group_uc"})
public class MatrixController
extends BaseController<MatrixManager, Matrix> {
    @Resource
    MatrixManager matrixManager;
    @Resource
    MatrixColDefManager matrixColDefManager;

    @PostMapping(value={"/listJson"})
    @ApiOperation(value="\u77e9\u9635\u7ba1\u7406\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u77e9\u9635\u7ba1\u7406\u5217\u8868")
    public PageList<Matrix> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Matrix> queryFilter) throws Exception {
        User user = ContextUtil.getCurrentUser();
        if (!user.isAdmin()) {
            queryFilter.addFilter("createBy", (Object)user.getUserId(), QueryOP.EQUAL, FieldRelation.OR, "manager");
            queryFilter.addFilter("managerId", (Object)user.getUserId(), QueryOP.EQUAL, FieldRelation.OR, "manager");
        }
        return this.matrixManager.query(queryFilter);
    }

    @PostMapping(value={"/listDetail"})
    @ApiOperation(value="\u77e9\u9635\u7ba1\u7406\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u77e9\u9635\u7ba1\u7406\u5217\u8868")
    public PageList<Matrix> listDetail(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Matrix> queryFilter) throws Exception {
        PageList query = this.matrixManager.query(queryFilter);
        if (query.getRows() != null) {
            for (Matrix matrix : query.getRows()) {
                List<MatrixColDef> condList = this.matrixColDefManager.getCondList(matrix.getId());
                List<MatrixColDef> roleList = this.matrixColDefManager.getRoleList(matrix.getId());
                matrix.setCondList(condList);
                matrix.setRoleList(roleList);
            }
        }
        return query;
    }

    @GetMapping(value={"/getJson"})
    @ApiOperation(value="\u77e9\u9635\u7ba1\u7406\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u77e9\u9635\u7ba1\u7406\u6570\u636e\u8be6\u60c5")
    public Matrix get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        Matrix matrix = this.matrixManager.getDetail(id);
        return matrix;
    }

    @RequestMapping(value={"getByCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7f16\u7801/\u522b\u540d\u83b7\u53d6\u77e9\u9635", httpMethod="GET", notes="\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public Matrix getByAlias(@ApiParam(name="code", value="code", required=true) @RequestParam String code) throws Exception {
        if (BeanUtils.isEmpty((Object)code)) {
            return null;
        }
        Matrix matrix = this.matrixManager.getByCode(code);
        if (BeanUtils.isNotEmpty((Object)((Object)matrix))) {
            List<MatrixColDef> condList = this.matrixColDefManager.getCondList(matrix.getId());
            List<MatrixColDef> roleList = this.matrixColDefManager.getRoleList(matrix.getId());
            matrix.setCondList(condList);
            matrix.setRoleList(roleList);
        }
        return matrix;
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u77e9\u9635\u7ba1\u7406\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u77e9\u9635\u7ba1\u7406\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="matrix", value="\u77e9\u9635\u7ba1\u7406\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody Matrix matrix) throws Exception {
        String msg = "\u4fdd\u5b58\u77e9\u9635\u7ba1\u7406\u6210\u529f";
        Boolean isCodeExist = this.matrixManager.isCodeExist(matrix.getCode(), matrix.getId());
        if (isCodeExist.booleanValue()) {
            return new CommonResult(false, "\u522b\u540d\u5df2\u5b58\u5728");
        }
        this.matrixManager.saveMatrix(matrix);
        return new CommonResult(msg);
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u77e9\u9635\u7ba1\u7406\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u77e9\u9635\u7ba1\u7406\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.matrixManager.deleLogical(ids);
        return new CommonResult(true, "\u6279\u91cf\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/publish"})
    @ApiOperation(value="\u53d1\u5e03", httpMethod="GET", notes="publish")
    public CommonResult<String> publish(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        this.matrixManager.publish(id);
        return new CommonResult(true, "\u53d1\u5e03\u6210\u529f");
    }

    @GetMapping(value={"/saveManager"})
    @ApiOperation(value="\u4fdd\u5b58\u7ba1\u7406\u5458", httpMethod="GET", notes="saveManager")
    public CommonResult<String> saveManager(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id, @ApiParam(name="userId", value="\u7ba1\u7406\u5458userId", required=true) @RequestParam String userId, @ApiParam(name="fullname", value="\u7ba1\u7406\u5458\u540d\u79f0", required=true) @RequestParam String fullname) throws Exception {
        Matrix matrix = (Matrix)this.matrixManager.get((Serializable)((Object)id));
        matrix.setManagerId(userId);
        matrix.setManagerName(fullname);
        this.matrixManager.update((Model)matrix);
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/getUsers"})
    @ApiOperation(value="\u83b7\u53d6\u77e9\u9635\u914d\u7f6e\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u77e9\u9635\u914d\u7f6e\u6570\u636e")
    public List<Map<String, Object>> getUsers(@RequestBody Map<String, Object> params) throws Exception {
        return this.matrixManager.getUsers(params);
    }

    @PostMapping(value={"/data/list/{matrixId}"})
    @ApiOperation(value="\u83b7\u53d6\u77e9\u9635\u914d\u7f6e\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u77e9\u9635\u914d\u7f6e\u6570\u636e")
    @ResponseBody
    public Object dataList(@ApiParam(name="matrixId", value="\u77e9\u9635id") @PathVariable String matrixId, @ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Matrix> queryFilter) throws Exception {
        Map<String, Object> map = this.matrixManager.getData(matrixId, queryFilter.getPageBean());
        return map;
    }

    @GetMapping(value={"/data/getOneData"})
    @ApiOperation(value="\u83b7\u53d6\u67d0\u6761\u6570\u636e", httpMethod="GET", notes="\u83b7\u53d6\u67d0\u6761\u6570\u636e")
    @ResponseBody
    public Object getOneData(@ApiParam(name="pk", value="pk") @RequestParam String pk, @ApiParam(name="matrixId", value="matrixId") @RequestParam String matrixId) throws Exception {
        if (StringUtil.isNotEmpty((String)pk)) {
            Map<String, Object> map = this.matrixManager.getOneData(matrixId, pk);
            return map;
        }
        Map<String, Object> map = this.matrixManager.getBlankOneData(matrixId);
        return map;
    }

    @PostMapping(value={"/data/save/{matrixId}"})
    @ApiOperation(value="\u83b7\u53d6\u77e9\u9635\u914d\u7f6e\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u77e9\u9635\u914d\u7f6e\u6570\u636e")
    public CommonResult<String> dataSave(@ApiParam(name="matrixId", value="\u77e9\u9635id") @PathVariable String matrixId, @ApiParam(name="data", value="data") @RequestBody String data) throws Exception {
        this.matrixManager.saveData(matrixId, data);
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
    }

    @DeleteMapping(value={"/data/remove/{matrixId}"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6570\u636e\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u6570\u636e\u8bb0\u5f55")
    public CommonResult<String> dataRemove(@ApiParam(name="matrixId", value="\u77e9\u9635id") @PathVariable String matrixId, String ... ids) throws Exception {
        this.matrixManager.dataRemove(matrixId, ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }
}

