/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.processManagermant.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.contract.manager.ContractManager;
import com.artfess.cqxy.contract.model.Contract;
import com.artfess.cqxy.processManagermant.dao.ProgressManageReportDao;
import com.artfess.cqxy.processManagermant.manager.ProgressManageReportManager;
import com.artfess.cqxy.processManagermant.model.ProgressManageReport;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.statistics.vo.StatisticsVo;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.cqxy.utils.ThreadUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProgressManageReportManagerImpl
extends BaseManagerImpl<ProgressManageReportDao, ProgressManageReport>
implements ProgressManageReportManager {
    private static Logger log = LoggerFactory.getLogger(ProgressManageReportManagerImpl.class);
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private SystemConfigFeignService scfs;
    @Autowired
    private SysDictionaryManager sdm;
    @Autowired
    private ProjectManagementManager pmm;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private GlobalRetrievalManager grm;
    @Autowired
    private ContractManager contractManager;

    public boolean saveOrUpdate(ProgressManageReport entity) {
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        boolean savedMain = super.saveOrUpdate((Object)entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.one.getCode());
            ele.setGroup("ProgressManageReport");
            ele.setNode(ProjectStatusEnum.one.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        this.pmm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.one.getCode()));
        ProjectManagement project = (ProjectManagement)((Object)this.pmm.getById((Serializable)((Object)entity.getProjectId())));
        if (null != project) {
            ProgressManageReport projectOvervieByProjectId = this.getProjectOvervieByProjectId(entity.getProjectId());
            project.setConstructionProgress(projectOvervieByProjectId.getWeeklyMouthlyWork());
            project.setConstructionProgress(projectOvervieByProjectId.getProjectOvervie().stripTrailingZeros().toPlainString());
            this.pmm.updateById((Object)project);
        }
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, ProgressManageReport entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pmm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.twenty.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.twenty.getName());
        globalRetrieval.setBizTableName(FunctionEnum.twenty.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.twenty.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.twenty.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.twenty.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.twenty.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.twenty.getFunctionPath());
        globalRetrieval.setSearchTitle(entity.getPortUserName() + "_" + entity.getProjectOvervie() + "_" + entity.getProgressDescription() + "_" + entity.getWeeklyMouthlyWork() + "_" + entity.getEngineeringChange() + "_" + entity.getNextStepPlan() + "_" + entity.getRemarks());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Override
    public ProgressManageReport getById(String id) {
        ProgressManageReport result = ((ProgressManageReportDao)this.baseMapper).getById(id);
        if (null != result) {
            result.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(id));
            result.setContractInfo((Contract)((Object)this.contractManager.getById((Serializable)((Object)result.getContractId()))));
        }
        return result;
    }

    @Override
    public PageList<ProgressManageReport> queryAllByPage(QueryFilter<ProgressManageReport> queryFilter) {
        BizUtils.handleFilter(queryFilter, "bpmr", "pm");
        IPage<ProgressManageReport> result = ((ProgressManageReportDao)this.baseMapper).queryAllByPage((IPage<ProgressManageReport>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ProgressManageReport>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (ProgressManageReport ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    @Override
    public BigDecimal getInvestmentTotal(String projectId, String portDate, String contractId) {
        BigDecimal total;
        if (StringUtils.isBlank((CharSequence)portDate)) {
            portDate = LocalDate.now().toString();
        }
        if ((total = ((ProgressManageReportDao)this.baseMapper).getInvestmentTotal(projectId, portDate, contractId)) == null) {
            total = new BigDecimal(0);
        }
        return total;
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId, String contractId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)contractId, (String)"\u5408\u540cID\u4e0d\u80fd\u4e3a\u7a7a");
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, ProgressManageReport.class, (ImportParams)new ImportParams());
            for (ProgressManageReport ele : data) {
                ele.setProjectId(projectId);
                ele.setContractId(contractId);
                this.save((Object)ele);
                this.handleRetrieval(new GlobalRetrieval(), ele);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDatatoExcel(QueryFilter<ProgressManageReport> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u8fc7\u7a0b\u7ba1\u7406-\u8fdb\u5ea6\u7ba1\u7406-\u5de5\u7a0b\u6708\u62a5-\u5bfc\u51fa\u7ed3\u679c";
        List portType = this.sdm.queryDictListItemsByCode("gcyb-tblx");
        List portUnit = this.sdm.queryDictListItemsByCode("gcyb-tbf");
        BizUtils.handleFilter(queryFilter, "bpmr", "pm");
        List data = ((ProgressManageReportDao)this.baseMapper).queryAllByPage((IPage<ProgressManageReport>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<ProgressManageReport>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        for (ProgressManageReport ele : data) {
            ele.setPortType(BizUtils.getDicValueByCode((List<DictModel>)portType, ele.getPortType()));
            ele.setPortUnit(BizUtils.getDicValueByCode((List<DictModel>)portUnit, ele.getPortUnit()));
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, ProgressManageReport.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper wrapper = (UpdateWrapper)new UpdateWrapper().set(StringUtils.isNotBlank((CharSequence)newProjectId), "PROJECT_ID_", (Object)newProjectId).in((Object)"PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update((Wrapper)wrapper);
    }

    @Override
    public List<Map<String, Object>> queryInvestment(StatisticsVo statisticsVo) {
        return ((ProgressManageReportDao)this.baseMapper).queryInvestment(statisticsVo);
    }

    @Override
    public ProgressManageReport getByProjectId(String projectId) {
        return ((ProgressManageReportDao)this.baseMapper).getByProjectId(projectId);
    }

    @Override
    public ProgressManageReport getProjectOvervieByProjectId(String projectId) {
        ProgressManageReport projectOvervieByProjectId = ((ProgressManageReportDao)this.baseMapper).getProjectOvervieByProjectId(projectId, LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM")));
        if (BeanUtils.isEmpty((Object)((Object)projectOvervieByProjectId))) {
            projectOvervieByProjectId = ((ProgressManageReportDao)this.baseMapper).getProjectOvervieByProjectId(projectId, LocalDate.now().minusMonths(1L).format(DateTimeFormatter.ofPattern("yyyy-MM")));
        }
        if (BeanUtils.isEmpty((Object)((Object)projectOvervieByProjectId))) {
            projectOvervieByProjectId = ((ProgressManageReportDao)this.baseMapper).getProjectOvervieByProjectId(projectId, null);
        }
        return projectOvervieByProjectId;
    }

    @Override
    public void recalManageReport(String projectId) {
        if (null != projectId && !"".equals(projectId)) {
            List<String> projectIds = Arrays.asList(projectId);
            this.recalManageReportLogic(projectIds);
        } else {
            List<String> projectIds = ((ProgressManageReportDao)this.baseMapper).selectProjectIds();
            if (null != projectIds && projectIds.size() > 0) {
                log.info("\u5de5\u7a0b\u6708\u62a5\u91cd\u7b97\u5f00\u59cb\uff0c\u9879\u76ee\u5171" + projectIds.size() + "\u4e2a");
                int projectNum = projectIds.size();
                int threadNum = 4;
                int threadTaskNum = ThreadUtil.getThreadTaskNum(threadNum, projectNum);
                log.info("\u5de5\u7a0b\u6708\u62a5\u91cd\u7b97-\u5f00\u542f\u591a\u7ebf\u7a0b, \u4efb\u52a1\u6570[{}], \u7ebf\u7a0b\u6570[{}], \u6bcf\u4e2a\u7ebf\u7a0b\u4efb\u52a1\u6570[{}]", new Object[]{projectNum, threadNum, threadTaskNum});
                for (int i = 0; i < threadNum; ++i) {
                    List<String> subList = projectIds.subList(i * threadTaskNum, i == threadNum - 1 ? projectNum : (i + 1) * threadTaskNum);
                    Future<Object[]> future = ThreadUtil.publicPool.submit(new recalManageReportThread(subList));
                }
            }
        }
        log.info("\u5de5\u7a0b\u6708\u62a5\u91cd\u7b97\u5168\u90e8\u5b8c\u6210");
    }

    @Override
    @Async
    public void updateProjectOvervie(ProgressManageReport progressManageReport) {
        System.out.println("1.\u5f02\u6b65\u8ba1\u7b97\u5de5\u7a0b\u6708\u62a5\u603b\u6295\u8d44\u7b49\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002" + (Object)((Object)progressManageReport));
        if (null == progressManageReport) {
            return;
        }
        Date portDate = progressManageReport.getPortDate();
        SimpleDateFormat syd = new SimpleDateFormat("yyyy-MM-dd");
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)progressManageReport.getContractId())) {
            queryWrapper.eq((Object)"CONTRACT_ID_", (Object)progressManageReport.getContractId());
        }
        queryWrapper.ge((Object)"PORT_DATE_", (Object)syd.format(portDate));
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        queryWrapper.orderByDesc((Object)"PORT_DATE_");
        List list = this.list((Wrapper)queryWrapper);
        System.out.println("\u5f02\u6b65\u8ba1\u7b97\u5de5\u7a0b\u6708\u62a5\u5f53\u524d\u6761\u6570\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3010" + list.size() + "\u3011");
        if (null != list && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ProgressManageReport pro = (ProgressManageReport)((Object)list.get(i));
                BigDecimal result = this.getInvestmentTotal(pro.getProjectId(), syd.format(pro.getPortDate()), pro.getContractId());
                pro.setProjectOvervie(result);
                BigDecimal addTotal = result.add(pro.getProgressDescription());
                Contract contract = (Contract)this.contractManager.get((Serializable)((Object)pro.getContractId()));
                if (null != contract && StringUtils.isNotBlank((CharSequence)contract.getContractAmount()) && contract.getContractAmount().compareTo("0") != 0) {
                    BigDecimal divide = addTotal.divide(new BigDecimal(contract.getContractAmount()), 4, 5);
                    BigDecimal multiply = divide.multiply(new BigDecimal("100"));
                    pro.setImageProgress(multiply.stripTrailingZeros().toPlainString());
                } else {
                    pro.setImageProgress("0");
                }
                if (!StringUtils.isNotBlank((CharSequence)pro.getInvestmentRatio()) || "0".equalsIgnoreCase(pro.getInvestmentRatio())) continue;
                BigDecimal divideProgressDescription = pro.getProgressDescription().divide(new BigDecimal(pro.getInvestmentRatio()), 2, 4);
                pro.setEngineeringChange(divideProgressDescription);
            }
            this.updateBatchById(list);
        }
        System.out.println("\u5f02\u6b65\u8ba1\u7b97\u5de5\u7a0b\u6708\u62a5\u4fee\u6539\u7ed3\u675f\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
    }

    private void recalManageReportLogic(List<String> projectIds) {
        for (String projectId : projectIds) {
            log.info("\u5de5\u7a0b\u6708\u62a5\u91cd\u7b97\u5f00\u59cb-projectId:" + projectId);
            List<ProgressManageReport> progressManageReports = ((ProgressManageReportDao)this.baseMapper).selectByProjectId(projectId);
            if (null != progressManageReports && progressManageReports.size() > 0) {
                for (ProgressManageReport report : progressManageReports) {
                    Date portDate = report.getPortDate();
                    String id = report.getId();
                    BigDecimal progressDescriptionTotal = ((ProgressManageReportDao)this.baseMapper).selectProgressDescriptionSum(projectId, portDate, id);
                    report.setProjectOvervie(progressDescriptionTotal);
                }
                this.saveOrUpdateBatch(progressManageReports);
            }
            log.info("\u5de5\u7a0b\u6708\u62a5\u91cd\u7b97\u5b8c\u6210-projectId:" + projectId);
        }
    }

    class recalManageReportThread
    implements Callable<Object[]> {
        private List<String> projectIds;

        public recalManageReportThread(List<String> projectIds) {
            this.projectIds = projectIds;
        }

        @Override
        public Object[] call() {
            ProgressManageReportManagerImpl.this.recalManageReportLogic(this.projectIds);
            return new Object[0];
        }
    }
}

