package com.artfess.base.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @Description:发送短信Vo
 * @Author: Rong Tao
 * @Date: 2025/5/23 14:14
 */
@Data
public class MobileSmsVo implements Serializable {

    @ApiModelProperty(value = "企业编号")
    private String SpCode;

    @ApiModelProperty(value = "用户名称")
    private String LoginName;

    @ApiModelProperty(value = "用户密码")
    private String Password;

    @ApiModelProperty(value = "短信内容（最大700个字符），需要包含【签名】")
    private String MessageContent;

    @ApiModelProperty(value = "手机号码(多个号码用,分隔，最多1000个号码)")
    private String UserNumber;

    @ApiModelProperty(value = "【可选】流水号，支持50位(数字和字母)，唯一")
    private String SerialNumber;

    @ApiModelProperty(value = "【可选】预约发送时间，格式:yyyyMMddhhmmss,如\n" +
            "‘20090901010101’，立即发送请填空")
    private String ScheduleTime;

    @ApiModelProperty(value = "【可选】扩展号")
    private String subPort;

}
