package com.artfess.base.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * Package com.scaffold.util.Enum
 * date 2020/3/6 14:28
 * author 陈实
 * Description:
 */
public enum LogType {
    BIZ("BIZ", "业务日志"),

    SYS("SYS", "系统日志"),

    OPERATION("OPERATION", "操作日志"),

    INTEGRATION("INTEGRATION", "集成日志"),

    WORKFLOW("WORKFLOW", "流程日志"),

    PERMISSION("PERMISSION", "授权日志"),

    AUDIT("AUDIT", "审计日志");

    private String id;
    private String name;

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    private LogType(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public static LogType fromId(String id) {
        String str = id;
        int i = -1;
        switch (str.hashCode()) {
            case 65779:
                if (str.equals("BIZ"))
                    i = 0;
                break;
            case 82605:
                if (str.equals("SYS"))
                    i = 1;
                break;
            case -985658956:
                if (str.equals("INTEGRATION"))
                    i = 2;
                break;
            case 818005951:
                if (str.equals("WORKFLOW"))
                    i = 3;
                break;
            case -32525873:
                if (str.equals("PERMISSION"))
                    i = 4;
        }
        switch (i) {
            case 0:
                return BIZ;
            case 1:
                return SYS;
            case 2:
                return INTEGRATION;
            case 3:
                return WORKFLOW;
            case 4:
                return PERMISSION;
        }
        throw new RuntimeException(String.format("无效操作类型类型“%s”。",
                new Object[] { String.valueOf(id) }));
    }


    public static Map<String, String> getData() {
        Map<String, String> map = new HashMap<String, String>(values().length);
        for (LogType c : values()) {
            map.put(String.valueOf(c.getId()), c.getName());
        }
        return map;
    }
}
