package com.artfess.base.controller;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.MobileSmsManager;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.PinyinUtil;
import com.artfess.base.vo.MobileSmsResultVo;
import com.artfess.base.vo.MobileSmsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.time.LocalDateTime;
import java.util.Optional;


@RestController
@RequestMapping("/mobile/sms/v1/")
@Api(tags="短信通知")
@ApiGroup(group = {ApiGroupConsts.GROUP_UC})
public class MobileSmsController {
    @Resource
    private MobileSmsManager mobileSmsManager;

    @PostMapping("/sendMessage")
    @ApiOperation("发送短信通知")
    public CommonResult<String> sendMessage(@RequestBody MobileSmsVo vo) {
        return CommonResult.success(mobileSmsManager.SendSms(vo), "保存成功");
    }

}

