package com.artfess.cgpt.winbind.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;

/**
 * 成交通知明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@ApiModel(value="BizWinBiddingNoticeDetaile对象", description="成交通知明细表")
@Data
@TableName("biz_win_bidding_notice_detaile")
public class BizWinBiddingNoticeDetaile extends BizNoModel<BizWinBiddingNoticeDetaile> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "评标记录ID")
    @TableField("EVALUATION_ID_")
    private String evaluationId;

    @ApiModelProperty(value = "中标通知ID")
    @TableField("WIN_NOTICE_ID_")
    private String winNoticeId;

    @ApiModelProperty(value = "采购立项编号")
    @TableField("NOTICE_CODE_")
    private String noticeCode;

    @ApiModelProperty(value = "采购立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "采购立项名称")
    @TableField("NOTICE_NAME_")
    private String noticeName;

    @ApiModelProperty(value = "采购立项明细ID")
    @TableField("NOTICE_DETAILED_ID_")
    private String noticeDetailedId;

    @ApiModelProperty(value = "物料ID")
    @TableField("MAT_ID_")
    private String matId;

    @ApiModelProperty(value = "企业物料编号")
    @TableField("MAT_CODE_")
    @Excel(name = "企业物料编号")
    private String matCode;

    @ApiModelProperty(value = "平台物料号")
    @TableField("MAT_PLATCODE_")
    @Excel(name = "平台物料编号")
    private String matPlatcode;

    @ApiModelProperty(value = "物料分类编号")
    @TableField("MAT_CATEGORY_CODE_")
    private String matCategoryCode;

    @ApiModelProperty(value = "物料名称")
    @TableField("MAT_NAME_")
    @Excel(name = "物料名称")
    private String matName;

    @ApiModelProperty(value = "物料牌号")
    @TableField("MAT_MATERIAL_")
    @Excel(name = "物料牌号")
    private String matMaterial;

    @ApiModelProperty(value = "规格型号")
    @TableField("MAT_SPEC_")
    @Excel(name = "规格型号")
    private String matSpec;

    @ApiModelProperty(value = "需求数量")
    @TableField("MAT_NUM_")
    @Excel(name = "数量")
    private BigDecimal matNum;

    @ApiModelProperty(value = "计量单位")
    @TableField("MAT_UNIT_")
    @Excel(name = "计量单位")
    private String matUnit;

    @ApiModelProperty(value = "采购方式（1：平台定价，2：合同采购，3：企业线下定价【单一采购】）")
    @TableField("PROCUREMENT_METHOD_")
    private Integer procurementMethod;

    @ApiModelProperty(value = "招标方式（1：招标采购，2：询比价采购，3：竞价采购，"+
            "4：竞争性谈判，5：单一来源采购，6：多源采购，7：邀请招标采购）")
    @TableField("APPLICATION_METHOD_")
    private Integer applicationMethod;

    @ApiModelProperty(value = "需求日期")
    @TableField("DEMAND_DATE")
    private LocalDate demandDate;

    @ApiModelProperty(value = "有无资质要求（0：无，1：有）")
    @TableField("HAS_QUALIFICATION_")
    private Integer hasQualification;

    @ApiModelProperty(value = "计划价格")
    @TableField("PLANNED_PRICE_")
    private BigDecimal plannedPrice;

    @ApiModelProperty(value = "品牌")
    @TableField("MAT_BRAND_")
    @Excel(name = "品牌")
    private String matBrand;

    @ApiModelProperty(value = "基础扩展")
    @TableField("MAT_BASE_EXT_")
    @Excel(name = "基础扩展")
    private String matBaseExt;

    @ApiModelProperty(value = "其他扩展")
    @TableField("MAT_OTHER_EXT_")
    @Excel(name = "其他扩展")
    private String matOtherExt;

    @ApiModelProperty(value = "是否含税价（1：含税，2：不含税）")
    @TableField("IS_TAX_")
    private Integer isTax;

    @ApiModelProperty(value = "税率(%)")
    @TableField("TAX_RATE_")
    @Excel(name = "税率(%)")
    private Integer taxRate;

    @ApiModelProperty(value = "中标单价")
    @TableField("WIN_BID_PRICE_")
    private BigDecimal winBidPrice;

    @ApiModelProperty(value = "中标金额（中标单价*分配数量）")
    @TableField("WIN_BID_AMOUNT_")
    private BigDecimal winBidAmount;

    @ApiModelProperty(value = "状态（1：已发布（已确认），2：待确认，3：草稿，4：不同意）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "确认时间")
    @TableField("CONFIRM_TIME_")
    private LocalDateTime confirmTime;

    @ApiModelProperty(value = "供货数量（中标数量）")
    @TableField("SHARE_ALLOCATION_NUM_")
    private BigDecimal shareAllocationNum;

    @ApiModelProperty(value = "供货份额分配率（%）")
    @TableField("SHARE_ALLOCATION_RATE_")
    private BigDecimal shareAllocationRate;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "采购公司ID")
    @TableField(exist = false)
    private String procureOrgId;
    @ApiModelProperty(value = "采购公司编码")
    @TableField(exist = false)
    private String procureOrgCode;
    @ApiModelProperty(value = "采购公司名称")
    @TableField(exist = false)
    private String procureOrgName;
    @ApiModelProperty(value = "供应商ID")
    @TableField(exist = false)
    private String vendorId;
    @ApiModelProperty(value = "供应商编码")
    @TableField(exist = false)
    private String vendorCode;
    @ApiModelProperty(value = "供应商名称")
    @TableField(exist = false)
    private String vendorName;
    @ApiModelProperty(value = "立项类型（1：物料，2：项目）")
    @TableField(exist = false)
    private Integer noticeType;
    @ApiModelProperty(value = "是否代采（0.否，1.是），默认0")
    @TableField(exist = false)
    private Integer isAgencyProcure;

    @ApiModelProperty(value = "计划编号")
    @TableField("PLAN_CODE_")
    @Excel(name = "计划编号")
    private String planCode;

    @ApiModelProperty(value = "采购申请ID（关联采购申请表ID）")
    @TableField("APPLICATION_ID_")
    private String applicationId;

    @ApiModelProperty(value = "采购申请明细ID（关联采购申请表ID）")
    @TableField("APPLICATION_DETAIL_ID_")
    private String applicationDetailId;

    @ApiModelProperty(value = "合同生成状态（1.未生成，2.已生成），默认1")
    @TableField("CONTRACT_GENERATE_STATUS_")
    private Integer contractGenerateStatus;

    @ApiModelProperty(value = "承兑时间（1·12个月）")
    @TableField("ACCEPTANCE_TIME_")
    @Excel(name = "承兑时间（月）")
    private Integer acceptanceTime;

    @ApiModelProperty(value = "挂账时间（1·12个月）")
    @TableField("PENDING_TIME_")
    @Excel(name = "挂账时间（月）")
    private Integer pendingTime;

    @ApiModelProperty(value = "送货地址")
    @TableField("UNLOAD_ADDRESS_")
    @Excel(name = "送货地址")
    private String unloadAddress;
    @ApiModelProperty(value = "企业补充说明")
    @TableField("PUR_NOTE_")
    @Excel(name = "企业补充说明")
    private String purNote;
    @ApiModelProperty(value = "付款方式（1：现金，2：承兑）,默认1")
    @TableField("QUOTATION_METHOD_")
    private Integer quotationMethod;

    @ApiModelProperty(value = "中标人补充说明")
    @TableField("TENDER_EXPLAIN_")
    private String tenderExplain;

    @ApiModelProperty(value = "明细来源类型（1.项目库引入，2.项目申请引入，3.手工添加，4.自动生成）")
    @TableField("PROJECT_SOURCE_TYPE_")
    private Integer projectSourceType;

    @ApiModelProperty(value = "项目申请ID（关联项目申请表ID）")
    @TableField("PROJECT_INFO_ID_")
    private String projectInfoId;

    @ApiModelProperty(value = "项目库ID（关联项目库ID）")
    @TableField("PROJECT_LEDGER_ID_")
    private String projectLedgerId;

    @ApiModelProperty(value = "项目库编号（关联项目库编号）")
    @TableField("PROJECT_LEDGER_CODE_")
    private String projectLedgerCode;

    @ApiModelProperty(value = "明细类型（1.服务，2.工程，3.设备，4.物资），默认4")
    @TableField("DETAIL_TYPE_")
    private Integer detailType;

    @ApiModelProperty(value = "服务开始时间")
    @TableField("SERVICE_START_TIME_")
    private LocalDate serviceStartTime;

    @ApiModelProperty(value = "服务结束时间")
    @TableField("SERVICE_END_TIME_")
    private LocalDate serviceEndTime;

    @ApiModelProperty(value = "建筑面积（平方米）")
    @TableField("BUILDING_AREA_")
    private BigDecimal buildingArea;

    @ApiModelProperty(value = "建筑工程及公用系统(万元)")
    @TableField("CONSTRUCTION_ENGINEERING_")
    private BigDecimal constructionEngineering;

    @ApiModelProperty(value = "设备购置及安装(万元)")
    @TableField("EQUIPMENT_PROCUREMENT_")
    private BigDecimal equipmentProcurement;

    @ApiModelProperty(value = "其他费用(万元)")
    @TableField("OTHER_EXPENSES_")
    private BigDecimal otherExpenses;

    @ApiModelProperty(value = "设备分类（1.下料设备，2.铆焊设备，3.机加设备，4.热表设备，5.装配设备，6.检测设备，7.其他设备）")
    @TableField("EQUIPMENT_CLASSIFICATION_")
    private Integer equipmentClassification;

    @ApiModelProperty(value = "技术要求（设备使用）")
    @TableField("TECHNICAL_REQUIREMENT_")
    private String technicalRequirement;

    @ApiModelProperty(value = "项目状态（1.立项、2.在建、3.竣工 、4.终止）")
    @TableField("PROJECT_STATUS_")
    private Integer projectStatus;

    @ApiModelProperty(value = "项目描述")
    @TableField("PROJECT_DESCRIPT_")
    private String projectDescript;

    @ApiModelProperty(value = "责任人ID")
    @TableField("PERSON_LIABLE_ID_")
    private String personLiableId;

    @ApiModelProperty(value = "责任人姓名")
    @TableField("PERSON_LIABLE_NAME_")
    private String personLiableName;

    @ApiModelProperty(value = "责任人联系方式")
    @TableField("PERSON_LIABLE_PHONE_")
    private String personLiablePhone;

    @ApiModelProperty(value = "保证金（元），默认0")
    @TableField("BOND_")
    private BigDecimal bond;

}
