package com.artfess.cgpt.winbind.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.cgpt.winbind.model.BizWinBiddingNoticeDetaile;
import com.artfess.base.manager.BaseManager;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 中标通知确认记录表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
public interface BizWinBiddingNoticeDetaileManager extends BaseManager<BizWinBiddingNoticeDetaile> {

    List<BizWinBiddingNoticeDetaile> getByPid(String id);


    void removeByPid(String id);

    /**
     * 更新状态
     * @param ids
     * @param status
     */
    void updateStatusById(String ids, Integer status);

    /**
     * 分页查询所有数据（联查主表）
     * @param queryFilter
     * @return
     */
    PageList<BizWinBiddingNoticeDetaile> queryJoinMasterByPage(QueryFilter<BizWinBiddingNoticeDetaile> queryFilter);

    /**
     * 根据Excel文件转换数据
     * @param file 文件
     * @throws Exception
     */
    List<BizWinBiddingNoticeDetaile> excelToData(MultipartFile file) throws Exception;

}
