package com.artfess.cgpt.winbind.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.cgpt.violate.manager.BizViolateRecordManager;
import com.artfess.cgpt.violate.model.BizViolateRecord;
import com.artfess.cgpt.winbind.model.BizWinBiddingNotice;
import com.artfess.cgpt.winbind.vo.BiddingNoticeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.winbind.model.BizWinBiddingNoticeDetaile;
import com.artfess.cgpt.winbind.manager.BizWinBiddingNoticeDetaileManager;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.List;

/**
 * 中标通知确认记录表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@RestController
@RequestMapping("/bizWinBiddingNoticeDetaile/v1/")
@Api(tags = "中标通知确认记录")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizWinBiddingNoticeDetaileController extends BaseController<BizWinBiddingNoticeDetaileManager, BizWinBiddingNoticeDetaile> {

    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询数据")
    public CommonResult<PageList<BizWinBiddingNoticeDetaile>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizWinBiddingNoticeDetaile> queryFilter){
        PageList<BizWinBiddingNoticeDetaile> result = baseService.query(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/pageWinNotice")
    @ApiOperation(value = "M-分页查询数据（联查主表）")
    public CommonResult<PageList<BizWinBiddingNoticeDetaile>> pageWinNotice(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizWinBiddingNoticeDetaile> queryFilter){
        PageList<BizWinBiddingNoticeDetaile> result = baseService.queryJoinMasterByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "S-查询详情")
    public CommonResult<BizWinBiddingNoticeDetaile> selectOne(@RequestParam String id){
        BizWinBiddingNoticeDetaile result=baseService.get(id);
        return new CommonResult(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除")
    public CommonResult remove(@RequestParam List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/save")
    @ApiOperation(value = "S-添加或修改")
    public CommonResult save(@RequestBody BizWinBiddingNoticeDetaile detaile) {
        baseService.saveOrUpdate(detaile);
        return new CommonResult<>(true, "操作成功");
    }


    @PostMapping("/updateStatusById")
    @ApiOperation(value = "M-更新状态")
    public CommonResult updateStatusById(@RequestParam("ids") String ids,@RequestParam("status") Integer status){
        baseService.updateStatusById(ids,status);
        return new CommonResult<>(true,"操作成功");
    }

    /**
     * 根据Excel文件转换数据
     * @param file Excel文件
     */
    @PostMapping("/excelToData")
    @ApiOperation(value = "M-根据Excel文件转换数据")
    public CommonResult<List<BizWinBiddingNoticeDetaile>> excelToData(@RequestParam("file") MultipartFile file) throws Exception{
        List<BizWinBiddingNoticeDetaile> result = baseService.excelToData(file);
        return new CommonResult<>(true,"操作成功",result);
    }

}
