package com.artfess.cgpt.violate.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 竞价违约记录表
 *
 * @Dept 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@ApiModel(value="BizViolateRecord对象", description="竞价违约记录表")
@Data
@TableName("biz_violate_record")
public class BizViolateRecord extends BizModel<BizViolateRecord> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "采购立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "采购立项编号")
    @TableField("NOTICE_CODE_")
    private String noticeCode;

    @ApiModelProperty(value = "采购立项标题")
    @TableField("NOTICE_TITLE_")
    private String noticeTitle;

    @ApiModelProperty(value = "采购公司ID")
    @TableField("MAT_ORG_ID_")
    private String matOrgId;

    @ApiModelProperty(value = "采购商编号")
    @TableField("MAT_ORG_CODE_")
    private String matOrgCode;

    @ApiModelProperty(value = "采购商名称")
    @TableField("MAT_ORG_NAME_")
    private String matOrgName;

    @ApiModelProperty(value = "供应商ID")
    @TableField("SUPPLIER_ORG_ID_")
    private String supplierOrgId;

    @ApiModelProperty(value = "供应商编号")
    @TableField("SUPPLIER_ORG_CODE_")
    private String supplierOrgCode;

    @ApiModelProperty(value = "供应商名称")
    @TableField("SUPPLIER_ORG_NAME_")
    private String supplierOrgName;

    @ApiModelProperty(value = "违约用户ID")
    @TableField("USER_ID_")
    private String userId;

    @ApiModelProperty(value = "违约用户账号")
    @TableField("USER_ACCOUNT_")
    private String userAccount;

    @ApiModelProperty(value = "违约用户名称")
    @TableField("USER_NAME_")
    private String userName;

    @ApiModelProperty(value = "违约公司ID")
    @TableField("ORG_ID_")
    private String orgId;

    @ApiModelProperty(value = "违约公司编号")
    @TableField("ORG_CODE_")
    private String orgCode;

    @ApiModelProperty(value = "违约公司名称")
    @TableField("ORG_NAME_")
    private String orgName;

    @ApiModelProperty(value = "采购类型（1：招标采购，2：询比价采购，3：竞价采购，"
            +"4：竞争性谈判，5：单一来源采购，6：多源采购，7：框架协议，"
            +"8：邀请招标采购）")
    @TableField("PROCURE_TYPE_")
    private Integer procureType;

    @ApiModelProperty(value = "标的类型（1：物资，2：项目）")
    @TableField("NOTICE_TYPE_")
    private Integer noticeType;

    @ApiModelProperty(value = "违约类型（1：采购商，2：供应商，默认2）")
    @TableField("VIOLATE_TYPE_")
    private Integer violateType;

    @ApiModelProperty(value = "违约金额")
    @TableField("VIOLATE_PRICE_")
    private BigDecimal violatePrice;

    @ApiModelProperty(value = "违约时间")
    @TableField("VIOLATE_TIME_")
    private LocalDateTime violateTime;

    @ApiModelProperty(value = "违约原因附件id，如果企业不执行上传了附件，通过这个id进行查询")
    @TableField("VIOLATE_REASON_ID_")
    private String violateReasonId;

    @ApiModelProperty(value = "违约原因")
    @TableField("VIOLATE_REASON_")
    private String violateReason;

    @ApiModelProperty(value = "支付时间，违约扣取金额时间")
    @TableField("PAY_TIME_")
    private LocalDateTime payTime;

    @ApiModelProperty(value = "支付状态（1：未支付，2：支付中，3：已支付，默认1），违约扣取金额状态")
    @TableField("PAY_STATUS_")
    private Integer payStatus;

    @ApiModelProperty(value = "支付订单记录ID")
    @TableField("ORDER_ID_")
    private String orderId;

    @ApiModelProperty(value = "撤回状态（1：未撤回，2：已撤回，默认1）")
    @TableField("REVOKE_STATUS_")
    private Integer revokeStatus;

    @ApiModelProperty(value = "支付金额，实际扣取金额")
    @TableField("PAY_PRICE_")
    private BigDecimal payPrice;

    @ApiModelProperty(value = "成交通知ID")
    @TableField("WIN_NOTICE_ID_")
    private String winNoticeId;

    @ApiModelProperty(value = "采购商联系人")
    @TableField("MAT_CONTACTS_")
    private String matContacts;

    @ApiModelProperty(value = "采购商联系方式")
    @TableField("MAT_CONTACTS_PHONE_")
    private String matContactsPhone;

    @ApiModelProperty(value = "违约用户联系方式")
    @TableField("USER_MOBILE_")
    private String userMobile;

    @ApiModelProperty(value = "处理状态（1.未处理，2.没收保证金，3.流标），默认1")
    @TableField("HANDLE_STATUS_")
    private Integer handleStatus;

    @ApiModelProperty(value = "处理人ID")
    @TableField("HANDLE_USER_ID_")
    private String handleUserId;

    @ApiModelProperty(value = "处理人账号")
    @TableField("HANDLE_USER_ACCOUNT_")
    private String handleUserAccount;

    @ApiModelProperty(value = "处理人姓名")
    @TableField("HANDLE_USER_NAME_")
    private String handleUserName;

    @ApiModelProperty(value = "处理时间")
    @TableField("HANDLE_TIME_")
    private LocalDateTime handleTime;

}
