package com.artfess.cgpt.violate.manager.impl;

import com.artfess.cgpt.violate.model.BizViolateRecordDetail;
import com.artfess.cgpt.violate.dao.BizViolateRecordDetailDao;
import com.artfess.cgpt.violate.manager.BizViolateRecordDetailManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 竞价违约记录明细表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@Service
public class BizViolateRecordDetailManagerImpl extends BaseManagerImpl<BizViolateRecordDetailDao, BizViolateRecordDetail> implements BizViolateRecordDetailManager {


    @Override
    public List<BizViolateRecordDetail> getByPid(String pid) {
        QueryWrapper<BizViolateRecordDetail> wrapper = new QueryWrapper<>();
        wrapper.eq("VR_ID_",pid);
        wrapper.eq("IS_DELE_","0");
        return this.list(wrapper);
    }
}
