package com.artfess.cgpt.utils;

import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.http.Header;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DateUtils;
import com.artfess.cgpt.supplier.manager.EnterpriseManager;
import com.artfess.cgpt.supplier.model.Enterprise;
import com.artfess.cgpt.universal.enums.FileTypeEnum;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.util.ContextUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.jsonwebtoken.lang.Collections;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.*;


/**
 * 业务工具类
 *
 * @author 黎沐华
 * @date 2022/2/24 11:45
 */
@Component
public class BizUtils {
//    @Autowired
//    private ESBConfigPo esbConfigPo;

    /**
     * 获取当前登录组织编码
     * @return 组织编码
     */
    public static String getCurrentOrgCode(UCFeignService ucFeignService) {
        String orgId = ContextUtil.getCurrentOrgId();
        String orgCode = "";
        if(BeanUtils.isNotEmpty(orgId)){
            ObjectNode orgInfo = ucFeignService.getOrgByIdOrCode(orgId);
            if(BeanUtils.isNotEmpty(orgInfo)) orgCode = orgInfo.get("code").asText();
        }
        return orgCode;
    }

    /**
     * 获取下一个流水号
     * @param alias 流水号别名
     * @return 流水号
     */
    public static String getNextSerialNumber(SystemConfigFeignService scfService,String alias) {
        String platCode = scfService.getNextIdByAlias(alias);
        JSONObject jsonObject = new JSONObject(platCode);
        Object value = jsonObject.get("value");
        return value.toString();
    }




    /**
     * 根据当前用户获取手机号
     * @param ucFeignService ucFeignService类，直接在使用类中注入
     * @param userId 当前登陆用户id
     * @return 手机号
     */
    public static String currentIsBuyer(UCFeignService ucFeignService, String userId) {
        String result = "";
        CommonResult<JsonNode> userById = ucFeignService.getUserById(userId);
        if(BeanUtils.isNotEmpty(userById)){
            if(BeanUtils.isNotEmpty(userById.getValue().get("mobile"))){
                result = userById.getValue().get("mobile").asText();
            }
        }
        return result;
    }




    /**
     * 判断当前用户是否是买家
     * @param ucFeignService ucFeignService类，直接在使用类中注入
     * @return true：买家，false：卖家
     */
//    public static Boolean currentIsBuyer(UCFeignService ucFeignService){
//        //角色类型【true：买方，false：卖方】
//        boolean isBuyer = true;
//
//        //判断当前用户角色为买方还是卖方
//        if(BizUtils.isAdmin(ucFeignService)){
//            Set<String> set = new HashSet<String>();
//            List<ObjectNode> list = ucFeignService.getRoleListByAccount(ContextUtil.getCurrentUserOrNull().getAccount());
//            if(BeanUtils.isNotEmpty(list)){
//                for (ObjectNode objectNode : list) {
//                    set.add(objectNode.get("code").asText());
//                }
//            }
//            if(!set.contains("sysRole") && !set.contains("qrsk") && !set.contains("ld") && !set.contains("yyadmin")){
//                //如果用户是买方
////                if(set.contains("wzjp")){
////                }
//                //如果用户是卖方
//                if(set.contains("wzcz")){
//                    isBuyer = false;
//                }
//            }
//        }
//
//        return isBuyer;
//    }



    /**
     * 根据公司编码和角色过滤列表数据查询，如果是管理员或者角色是sysRole、ld、yyadmin则不过滤，否则过滤掉数据，只查询自己的数据
     * @param queryFilter 查询过滤条件
     * @param ucFeignService ucFeignService类，直接在使用类中注入
     * @param column 列名，用于过滤数据的列名
     * @return
     */
    public static QueryFilter addFilterByOrgCodeAndRole(QueryFilter queryFilter, UCFeignService ucFeignService, String column){
        //查询项目时通过项目人员增加查询条件，只有管理员或者可以管理此项目的人员才能查询到此项目
        IUser user= ContextUtil.getCurrentUser();
        // 如果是管理员或者没有项目权限
        if(null != user){
            boolean disableAll = false;
            Integer userType = user.getUserType();
            String userId = user.getUserId();
            String orgId = ContextUtil.getCurrentOrgId();
            ObjectNode orgInfo = ucFeignService.getOrgByIdOrCode(orgId);
            String orgCode = "";
            if(BeanUtils.isNotEmpty(orgInfo)){
                orgCode = orgInfo.get("code").asText();
            }
            CommonResult<JsonNode> userNode = ucFeignService.getUserById(userId);
            if (userNode.getState()) {
                JsonNode userJsonNode = userNode.getValue();
                if(null != userJsonNode){
                    userType = userJsonNode.get("userType").asInt();
                }
            }
            // 1.先通过用户类型判断，过滤掉超级管理员之类的用户
            if(userType != null && userType !=0 && userType != 1){
                // 2.再通过角色判断，过滤掉没有对应角色权限的人员
                // 获取当前用户拥有的所有角色
                Set<String> set = new HashSet<String>();
                List<ObjectNode> list = ucFeignService.getRoleListByAccount(user.getAccount());
                if(BeanUtils.isNotEmpty(list)){
                    for (ObjectNode objectNode : list) {
                        set.add(objectNode.get("code").asText());
                    }
                }
                if(!set.contains("sysRole") && !set.contains("qrsk") && !set.contains("ld") && !set.contains("yyadmin")){
                    disableAll = true;
                }
            }
            if(disableAll){
                queryFilter.addFilter(column, orgCode, QueryOP.EQUAL);
            }
        }
        return queryFilter;
    }


    /**
     * 根据公司和角色过滤列表数据查询，如果是管理员或者角色是sysRole、ld、yyadmin则不过滤，否则过滤掉数据，只查询自己的数据
     * @param queryFilter 查询过滤条件
     * @param ucFeignService ucFeignService类，直接在使用类中注入
     * @param column 列名，用于过滤数据的列名
     * @return
     */
    public static QueryFilter addFilterByUserOrgAndRole(QueryFilter queryFilter, UCFeignService ucFeignService, String column){
        //查询项目时通过项目人员增加查询条件，只有管理员或者可以管理此项目的人员才能查询到此项目
        IUser user= ContextUtil.getCurrentUser();
        // 如果是管理员或者没有项目权限
        if(null != user){
            boolean disableAll = false;
            Integer userType = user.getUserType();
            String userId = user.getUserId();
            String orgId = ContextUtil.getCurrentOrgId();
            CommonResult<JsonNode> userNode = ucFeignService.getUserById(userId);
            if (userNode.getState()) {
                JsonNode userJsonNode = userNode.getValue();
                if(null != userJsonNode){
                    userType = userJsonNode.get("userType").asInt();
                }
            }
            // 1.先通过用户类型判断，过滤掉超级管理员之类的用户
            if(userType != null && userType !=0 && userType != 1){
                // 2.再通过角色判断，过滤掉没有对应角色权限的人员
                // 获取当前用户拥有的所有角色
                Set<String> set = new HashSet<String>();
                List<ObjectNode> list = ucFeignService.getRoleListByAccount(user.getAccount());
                if(BeanUtils.isNotEmpty(list)){
                    for (ObjectNode objectNode : list) {
                        set.add(objectNode.get("code").asText());
                    }
                }
                if(!set.contains("sysRole") && !set.contains("qrsk") && !set.contains("ld") && !set.contains("yyadmin")){
                    disableAll = true;
                }
            }
            if(disableAll){
                queryFilter.addFilter(column, orgId, QueryOP.EQUAL,FieldRelation.OR,"orgQuery");
            }
        }
        return queryFilter;
    }

    /**
     * (包含集采管理员)根据公司和角色过滤列表数据查询，如果是管理员或者角色是sysRole、ld、yyadmin、jcgly则不过滤，否则过滤掉数据，只查询自己的数据
     * @param queryFilter 查询过滤条件
     * @param ucFeignService ucFeignService类，直接在使用类中注入
     * @param column 列名，用于过滤数据的列名
     * @return
     */
    public static QueryFilter addFilterByUserOrgAndRoleBusiness(QueryFilter queryFilter, UCFeignService ucFeignService, String column){
        //查询项目时通过项目人员增加查询条件，只有管理员或者可以管理此项目的人员才能查询到此项目
        IUser user = ContextUtil.getCurrentUser();
        // 如果是管理员或者没有项目权限
        if(null != user){
            boolean disableAll = false;
            Integer userType = user.getUserType();
            String userId = user.getUserId();
            String orgId = ContextUtil.getCurrentOrgId();
            CommonResult<JsonNode> userNode = ucFeignService.getUserById(userId);
            if (userNode.getState()) {
                JsonNode userJsonNode = userNode.getValue();
                if(null != userJsonNode){
                    userType = userJsonNode.get("userType").asInt();
                }
            }
            // 1.先通过用户类型判断，过滤掉超级管理员之类的用户
            if(null != userType && userType !=0 && userType != 1){
                // 2.再通过角色判断，过滤掉没有对应角色权限的人员
                // 获取当前用户拥有的所有角色
                Set<String> set = new HashSet<String>();
                List<ObjectNode> list = ucFeignService.getRoleListByAccount(user.getAccount());
                if(BeanUtils.isNotEmpty(list)){
                    for (ObjectNode objectNode : list) {
                        set.add(objectNode.get("code").asText());
                    }
                }
                if(!set.contains("sysRole") && !set.contains("qrsk") && !set.contains("ld") && !set.contains("yyadmin") && !set.contains("jcgly")){
                    disableAll = true;
                }
            }
            if(disableAll){
                queryFilter.addFilter(column, orgId, QueryOP.EQUAL);
            }
        }
        return queryFilter;
    }


    /**
     * 根据历史组织编码和角色过滤列表数据查询，如果是管理员或者角色是sysRole、ld、yyadmin则不过滤，否则过滤掉数据，只查询自己的数据
     * @param queryFilter 查询过滤条件
     * @param ucFeignService ucFeignService类，直接在使用类中注入
     * @param column 列名，用于过滤数据的列名
     * @return
     */
    public static QueryFilter addFilterByHisOrgCodeAndRole(QueryFilter queryFilter, UCFeignService ucFeignService, String column, EnterpriseManager enterpriseManager){
        //查询项目时通过项目人员增加查询条件，只有管理员或者可以管理此项目的人员才能查询到此项目
        IUser user= com.artfess.uc.api.impl.util.ContextUtil.getCurrentUserOrNull();
        // 如果是管理员或者没有项目权限
        if(null != user){
            boolean disableAll = false;
            Integer userType = user.getUserType();
            String userId = user.getUserId();
            String orgId = com.artfess.uc.api.impl.util.ContextUtil.getCurrentOrgId();
            ObjectNode orgInfo = ucFeignService.getOrgByIdOrCode(orgId);
            String orgCode = "";
            if(BeanUtils.isNotEmpty(orgInfo)){
                orgCode = orgInfo.get("code").asText();
            }
            CommonResult<JsonNode> userNode = ucFeignService.getUserById(userId);
            if (userNode.getState()) {
                JsonNode userJsonNode = userNode.getValue();
                if(null != userJsonNode){
                    userType = userJsonNode.get("userType").asInt();
                }
            }
            // 1.先通过用户类型判断，过滤掉超级管理员之类的用户
            if(userType != null && userType !=0 && userType != 1){
                // 2.再通过角色判断，过滤掉没有对应角色权限的人员
                // 获取当前用户拥有的所有角色
                Set<String> set = new HashSet<String>();
                List<ObjectNode> list = ucFeignService.getRoleListByAccount(user.getAccount());
                if(BeanUtils.isNotEmpty(list)){
                    for (ObjectNode objectNode : list) {
                        set.add(objectNode.get("code").asText());
                    }
                }
                if(!set.contains("sysRole") && !set.contains("qrsk") && !set.contains("ld") && !set.contains("yyadmin")){
                    disableAll = true;
                }
            }
            if(disableAll){
                Enterprise enterprise = enterpriseManager.getByOrgIdOrCode(orgId,orgCode);
                queryFilter.addFilter(column, orgCode, QueryOP.EQUAL, FieldRelation.OR,"orgQuery");
                if(BeanUtils.isNotEmpty(enterprise)) {
                    queryFilter.addFilter(column, enterprise.getHistoryCompanyCode(), QueryOP.EQUAL, FieldRelation.OR,"orgQuery");
                }
            }
        }
        return queryFilter;
    }


    /**
     * 根据用户类型和角色过滤列表数据查询，如果是管理员或者角色是sysRole、ld、yyadmin则不过滤，否则过滤掉数据，只查询自己的数据
     * @param queryFilter 查询过滤条件
     * @param ucFeignService ucFeignService类，直接在使用类中注入
     * @param column 列名，用于过滤数据的列名
     * @return
     */
    public static QueryFilter addFilterByUserAndRole(QueryFilter queryFilter, UCFeignService ucFeignService, String column){
        //查询项目时通过项目人员增加查询条件，只有管理员或者可以管理此项目的人员才能查询到此项目
        IUser user= ContextUtil.getCurrentUser();
        // 如果是管理员或者没有项目权限
        if(null != user){
            boolean disableAll = false;
            Integer userType = user.getUserType();
            String userId = user.getUserId();
            CommonResult<JsonNode> userNode = ucFeignService.getUserById(userId);
            if (userNode.getState()) {
                JsonNode userJsonNode = userNode.getValue();
                if(null != userJsonNode){
                    userType = userJsonNode.get("userType").asInt();
                }
            }
            // 1.先通过用户类型判断，过滤掉超级管理员之类的用户
            if(userType != null && userType !=0 && userType != 1){
                // 2.再通过角色判断，过滤掉没有对应角色权限的人员
                // 获取当前用户拥有的所有角色
                Set<String> set = new HashSet<String>();
                List<ObjectNode> list = ucFeignService.getRoleListByAccount(user.getAccount());
                if(BeanUtils.isNotEmpty(list)){
                    for (ObjectNode objectNode : list) {
                        set.add(objectNode.get("code").asText());
                    }
                }
                if(!set.contains("sysRole") && !set.contains("ld") && !set.contains("yyadmin")){
                    disableAll = true;
                }
            }
            if(disableAll){
                queryFilter.addFilter(column, userId, QueryOP.EQUAL);
            }
        }
        return queryFilter;
    }

    /**
     * 判断是否为管理员
     * @param ucFeignService ucFeignService类，直接在使用类中注入
     * @return false:管理员，true：不是管理员
     */
    public static boolean isAdmin(UCFeignService ucFeignService){
        //查询项目时通过项目人员增加查询条件，只有管理员或者可以管理此项目的人员才能查询到此项目
        IUser user= ContextUtil.getCurrentUser();
        // 如果是管理员或者没有项目权限
        boolean disableAll = false;
        if(null != user){
            Integer userType = user.getUserType();
            String userId = user.getUserId();
            CommonResult<JsonNode> userNode = ucFeignService.getUserById(userId);
            if (userNode.getState()) {
                JsonNode userJsonNode = userNode.getValue();
                if(null != userJsonNode){
                    userType = userJsonNode.get("userType").asInt();
                }
            }
            // 1.先通过用户类型判断，过滤掉超级管理员之类的用户
            if(userType != null && userType !=0 && userType != 1){
                // 2.再通过角色判断，过滤掉没有对应角色权限的人员
                // 获取当前用户拥有的所有角色
                Set<String> set = new HashSet<String>();
                List<ObjectNode> list = ucFeignService.getRoleListByAccount(user.getAccount());
                if(BeanUtils.isNotEmpty(list)){
                    for (ObjectNode objectNode : list) {
                        set.add(objectNode.get("code").asText());
                    }
                }
                if(!set.contains("sysRole") && !set.contains("yygly") && !set.contains("yyadmin")){
                    disableAll = true;
                }
            }
        }
        return disableAll;
    }

    public static <T> List<T> list(List<T> list) {
        return null == list ? new ArrayList<T>() : list;
    }

    // 保留原有方法调用，避免过大改动
    public static QueryFilter handleFilter(QueryFilter queryFilter, String mAlias, String lAlias) {
        queryFilter.addFilter(mAlias + ".IS_DELE_", "0", QueryOP.EQUAL);
        queryFilter.addFilter(lAlias + ".IS_DELE_", "0", QueryOP.EQUAL);
        queryFilter.addFilter(lAlias + ".VALID_FLAG_", 1, QueryOP.EQUAL);
        return queryFilter;
    }

    /**
     * 由后缀名返回文件类型
     *
     * @param suffix
     * @return
//     */
//    public static Integer handleFileType(String suffix) {
//        if ("bmp,jpg,jpeg,png,gif,webp".indexOf(suffix) != -1) {
//            return Integer.valueOf(FileTypeEnum.one.getCode());
//        }
//        if ("docx,doc,xls,xlsx,ppt,pptx,pdf,htl,html,txt".indexOf(suffix) != -1) {
//            return Integer.valueOf(FileTypeEnum.two.getCode());
//        }
//        if ("rar,zip,7z,gz,bz,ace,uha,uda,zpaq".indexOf(suffix) != -1) {
//            return Integer.valueOf(FileTypeEnum.three.getCode());
//        }
//        if ("avi,wmv,mpg,mpeg,mov,rm,ram,swf,flv,mp4".indexOf(suffix) != -1) {
//            return Integer.valueOf(FileTypeEnum.four.getCode());
//        } else {
//            return Integer.valueOf(FileTypeEnum.five.getCode());
//        }
//    }

    /**
     * 将字符串的首字母转大写
     *
     * @param str 需要转换的字符串
     * @return
     */
    public static String captureName(String str) {
        // 进行字母的ascii编码前移，效率要高于截取字符串进行转换的操作
        char[] cs = str.toCharArray();
        cs[0] -= 32;
        return String.valueOf(cs);
    }

    public static String handleDateFormat(Date date) {
        return null == date ? "" : new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    public static String dateFormatChineseStyle(Date date) {
        return null == date ? "" : new SimpleDateFormat("yyyy年MM月dd日").format(date);
    }

    public static String handleStringFormat(String str) {
        if (org.apache.commons.lang3.StringUtils.isBlank(str)) {
            return "";
        }
        return str;
    }

    /**
     * 处理单元格
     *
     * @param workbook  工作蒲
     * @param sheetName Sheet名，获取对应Sheet以设置行高列宽
     * @param cell      单元格
     * @param value     填入单元格中的值
     * @param title     是否是标题
     */
    public static void handelCell(HSSFWorkbook workbook, String sheetName, HSSFCell cell, String value, boolean... title) {
        //单元格设置值
        cell.setCellValue(StringUtils.isEmpty(value) ? " " : value);
        //创建样式
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        //设置水平居中
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        //设置垂直居中
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        //设置边框
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        //设置字体
        HSSFFont font = workbook.createFont();
        font.setFontName("宋体");//设置字体名称
        font.setFontHeightInPoints((short) 12);//设置字号
        if (title.length == 1 && title[0]) {
            font.setFontHeightInPoints((short) 14);
            font.setBold(true);//设置是否加粗
        }
        font.setColor(IndexedColors.BLACK.index);//设置字体颜色
        cellStyle.setFont(font);
        //自动换行
        cellStyle.setWrapText(true);
        //渲染单元格
        cell.setCellStyle(cellStyle);
        //列宽自适应、设置行高
        HSSFSheet sheet = workbook.getSheet(sheetName);
        sheet.setColumnWidth(0, 6 * 256);
        // 解决自动设置列宽中文失效的问题
//        sheet.setColumnWidth(cell.getColumnIndex(), sheet.getColumnWidth(cell.getColumnIndex()) * 9 / 10);
        int colWidth = sheet.getColumnWidth(cell.getColumnIndex()) * 2;
        sheet.autoSizeColumn(cell.getColumnIndex());
        if (colWidth < 255 * 256) {
            sheet.setColumnWidth(cell.getColumnIndex(), colWidth < 3000 ? 3000 : colWidth);
        } else {
            sheet.setColumnWidth(cell.getColumnIndex(), 6000);
        }
        sheet.getRow(cell.getRowIndex()).setHeightInPoints(30);
    }

    /**
     * 处理单元格 解决Style数量过多问题
     *
     * @param workbook  工作蒲
     * @param sheetName Sheet名，获取对应Sheet以设置行高列宽
     * @param cell      单元格
     * @param value     填入单元格中的值
     * @param title     是否是标题
     */
    public static void handelCell(HSSFWorkbook workbook, HSSFCellStyle cellStyle, String sheetName, HSSFCell cell, String value, boolean... title) {
        //单元格设置值
        cell.setCellValue(StringUtils.isEmpty(value) ? " " : value);
        //设置水平居中
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        //设置垂直居中
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        //设置边框
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        //设置字体
        HSSFFont font = workbook.createFont();
        font.setFontName("宋体");//设置字体名称
        font.setFontHeightInPoints((short) 12);//设置字号
        if (title.length == 1 && title[0]) {
            font.setFontHeightInPoints((short) 14);
            font.setBold(true);//设置是否加粗
        }
        font.setColor(IndexedColors.BLACK.index);//设置字体颜色
        cellStyle.setFont(font);
        //自动换行
        cellStyle.setWrapText(true);
        //渲染单元格
        cell.setCellStyle(cellStyle);
        //列宽自适应、设置行高
        HSSFSheet sheet = workbook.getSheet(sheetName);
        sheet.setColumnWidth(0, 6 * 256);
        // 解决自动设置列宽中文失效的问题
//        sheet.setColumnWidth(cell.getColumnIndex(), sheet.getColumnWidth(cell.getColumnIndex()) * 9 / 10);
        int colWidth = sheet.getColumnWidth(cell.getColumnIndex()) * 2;
        sheet.autoSizeColumn(cell.getColumnIndex());
        if (colWidth < 255 * 256) {
            sheet.setColumnWidth(cell.getColumnIndex(), colWidth < 3000 ? 3000 : colWidth);
        } else {
            sheet.setColumnWidth(cell.getColumnIndex(), 6000);
        }
        sheet.getRow(cell.getRowIndex()).setHeightInPoints(30);
    }

    /**
     * 处理单元格 解决Style数量过多问题
     *
     * @param workbook  工作蒲
     * @param sheetName Sheet名，获取对应Sheet以设置行高列宽
     * @param cell      单元格
     * @param value     填入单元格中的值
     * @param title     是否是标题
     */
    public static void handelCell(HSSFWorkbook workbook, HSSFCellStyle cellStyle, HSSFFont font, String sheetName, HSSFCell cell, String value, boolean... title) {
        //单元格设置值
        cell.setCellValue(StringUtils.isEmpty(value) ? " " : value);
        //设置水平居中
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        //设置垂直居中
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        //设置边框
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        //设置字体
//        HSSFFont font = workbook.createFont();
        font.setFontName("宋体");//设置字体名称
        font.setFontHeightInPoints((short) 12);//设置字号
        if (title.length == 1 && title[0]) {
            font.setFontHeightInPoints((short) 14);
            font.setBold(true);//设置是否加粗
        }
        font.setColor(IndexedColors.BLACK.index);//设置字体颜色
        cellStyle.setFont(font);
        //自动换行
        cellStyle.setWrapText(true);
        //渲染单元格
        cell.setCellStyle(cellStyle);
        //列宽自适应、设置行高
        HSSFSheet sheet = workbook.getSheet(sheetName);
        sheet.setColumnWidth(0, 6 * 256);
        // 解决自动设置列宽中文失效的问题
//        sheet.setColumnWidth(cell.getColumnIndex(), sheet.getColumnWidth(cell.getColumnIndex()) * 9 / 10);
        int colWidth = sheet.getColumnWidth(cell.getColumnIndex()) * 2;
        sheet.autoSizeColumn(cell.getColumnIndex());
        if (colWidth < 255 * 256) {
            sheet.setColumnWidth(cell.getColumnIndex(), colWidth < 3000 ? 3000 : colWidth);
        } else {
            sheet.setColumnWidth(cell.getColumnIndex(), 6000);
        }
        sheet.getRow(cell.getRowIndex()).setHeightInPoints(30);
    }

    /**
     * 将金额转换为大写
     *
     * @param v
     * @return
     */
    public static String changeMoney(double v) {
        final String UNIT = "万千佰拾亿千佰拾万千佰拾元角分";
        final String DIGIT = "零壹贰叁肆伍陆柒捌玖";
        final double MAX_VALUE = 9999999999999.99D;
        if (v < 0 || v > MAX_VALUE) {
            return "参数非法!";
        }
        long l = Math.round(v * 100);
        if (l == 0) {
            return "零元整";
        }
        String strValue = l + "";
        // i用来控制数
        int i = 0;
        // j用来控制单位
        int j = UNIT.length() - strValue.length();
        String rs = "";
        boolean isZero = false;
        for (; i < strValue.length(); i++, j++) {
            char ch = strValue.charAt(i);
            if (ch == '0') {
                isZero = true;
                if (UNIT.charAt(j) == '亿' || UNIT.charAt(j) == '万' || UNIT.charAt(j) == '元') {
                    rs = rs + UNIT.charAt(j);
                    isZero = false;
                }
            } else {
                if (isZero) {
                    rs = rs + "零";
                    isZero = false;
                }
                rs = rs + DIGIT.charAt(ch - '0') + UNIT.charAt(j);
            }
        }
        if (!rs.endsWith("分")) {
            rs = rs + "整";
        }
        rs = rs.replaceAll("亿万", "亿");
        return rs;
    }

    /**
     * 根据字典值获取字典文本
     *
     * @param dic  字典集合
     * @param code 值
     * @return 文本
     */
    public static String getDicValueByCode(List<DictModel> dic, String code) {
        if (Collections.isEmpty(dic)) {
            return "";
        }
        for (DictModel ele : dic) {
            if (ele.getValue().equals(code)) {
                return ele.getName();
            }
        }
        return "";
    }

    // 重载以兼容数值型的code
    public static String getDicValueByCode(List<DictModel> dic, Integer code) {
        return getDicValueByCode(dic, String.valueOf(code));
    }

    /**
     * 从字典中获取对应值的code
     *
     * @param dic   字典
     * @param value 值
     * @return
     */
    public static String getDicCodeByValue(List<DictModel> dic, String value) {
        if (Collections.isEmpty(dic)) {
            return "";
        }
        for (DictModel ele : dic) {
            if (ele.getName().equals(value)) {
                return ele.getValue();
            }
        }
        return "";
    }

    // 重载以兼容数值型的code
    public static Integer getDicCodeByValue_Int(List<DictModel> dic, String value) {
        if (Collections.isEmpty(dic)) {
            return null;
        }
        for (DictModel ele : dic) {
            if (ele.getName().equals(value)) {
                return Integer.valueOf(ele.getValue());
            }
        }
        return null;
    }

    /**
     * 将数字翻译为英文单词
     *
     * @param value 数字
     * @return 英文单词
     */
    public static String convertNumber(String value) {
        switch (value) {
            case "1":
                return "one";
            case "2":
                return "two";
            case "3":
                return "three";
            case "4":
                return "four";
            case "5":
                return "five";
            case "6":
                return "six";
            case "7":
                return "seven";
            case "8":
                return "eight";
            case "9":
                return "nine";
            case "10":
                return "ten";
            case "11":
                return "eleven";
            case "12":
                return "twelve";
            case "13":
                return "thirteen";
            case "14":
                return "fourteen";
            case "15":
                return "fifteen";
            default:
                return value;
        }
    }

    // 重载以兼容数值型的数值
    public static String convertNumber(Integer value) {
        return convertNumber(String.valueOf(value));
    }

    /**
     * 将数字翻译为汉字
     *
     * @param value 数字
     * @return 汉字
     */
    public static String converttoChinaNumber(String value) {
        switch (value) {
            case "1":
                return "一";
            case "2":
                return "二";
            case "3":
                return "三";
            case "4":
                return "四";
            case "5":
                return "五";
            case "6":
                return "六";
            case "7":
                return "七";
            case "8":
                return "八";
            case "9":
                return "九";
            case "10":
                return "十";
            case "11":
                return "十一";
            case "12":
                return "十二";
            case "13":
                return "十三";
            case "14":
                return "十四";
            case "15":
                return "十五";
            default:
                return "";
        }
    }

    // 重载以兼容数值型的数值
    public static String converttoChinaNumber(Integer value) {
        return converttoChinaNumber(String.valueOf(value));
    }

//    /**
//     * 设置EasyPOI导出参数
//     *
//     * @param fileName 文件名
//     * @return 导出参数
//     */
//    public static ExportParams getExportParams(String fileName) {
//        ExportParams exportParams = new ExportParams(null, fileName);
//        exportParams.setStyle(EasyPoiStyle.class);
//        exportParams.setType(ExcelType.XSSF);
//        return exportParams;
//    }

    //赋默认值
    public static void setDefaultValue(Object object) {
        final String defaultStr = "";
        final Date defaultDate = new Date();
        final BigDecimal defaultDecimal = new BigDecimal(0);
        try {
            Class clazz = object.getClass();
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; i++) {
                Field field = fields[i];
                String fieldName = field.getName();
                Class fieldClass = field.getType();
                field.setAccessible(true); //设置访问权限
                if (isFieldValueNull(fieldName, object)) {
                    if (fieldClass == Integer.class) {
                        field.set(object, defaultDecimal.intValue());
                    } else if (fieldClass == Long.class) {
                        field.set(object, defaultDecimal.longValue());
                    } else if (fieldClass == Float.class) {
                        field.set(object, defaultDecimal.doubleValue());
                    } else if (fieldClass == BigDecimal.class) {
                        field.set(object, defaultDecimal);
                    } else if (fieldClass == Date.class) {
                        field.set(object, defaultDate);
                    } else if (fieldClass == String.class) {
                        field.set(object, defaultStr); // 设置值
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }

    //判断字段是否为空
    private static boolean isFieldValueNull(String fieldName, Object object) throws ClassNotFoundException {
        boolean isNUll = false;
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = object.getClass().getMethod(getter, new Class[]{});
            Object value = method.invoke(object, new Object[]{});
            if (value == null || "null".equals(String.valueOf(value))) {
                isNUll = true;
            }
            return isNUll;
        } catch (Exception e) {
            return isNUll;
        }
    }

    public static String getYearByQueryFields(List<QueryField> queryFields) throws Exception {
        String year = null;
        for (QueryField ele : queryFields) {
            if ("COMMENCEMENT_TIME_".equalsIgnoreCase(ele.getProperty())) {
                if (null != ele.getValue() && ele.getValue() instanceof Date) {
                    year = new SimpleDateFormat("yyyy").format(DateUtils.parseDate(ele.getValue().toString(), "yyyy-MM-dd"));
//                    year = String.valueOf(((Date) ele.getValue()).getYear());
                }
                if (null != ele.getValue() && ele.getValue() instanceof List) {
                    List value = (List) ele.getValue();
                    if (null != value && value.size() > 0) {
                        year = new SimpleDateFormat("yyyy").format(DateUtils.parseDate(value.get(0).toString(), "yyyy-MM-dd"));
                    }
                }
                break;
            }
            if (null == year) {
                if ("CREATE_TIME_".equalsIgnoreCase(ele.getProperty())) {
                    if (null != ele.getValue() && ele.getValue() instanceof Date) {
                        year = String.valueOf(((LocalDateTime) ele.getValue()).getYear());
                    }
                    break;
                }
            }
        }

        return year;
    }

    public static Boolean isProjectIdFields(List<QueryField> queryFields) {
        for (QueryField ele : queryFields) {
            if ("pm.ID_".equalsIgnoreCase(ele.getProperty()) || ele.getProperty().toUpperCase().indexOf("PROJECT_ID_") > 0) {
                return false;
            }
        }
        return true;
    }




    public static void removeSame(List<Map<String, Object>> list) {
        for (int i = 0; i < list.size() - 1; i++) {
            for (int j = list.size() - 1; j > i; j--) {
                if (list.get(j).get("tableName").equals(list.get(i).get("tableName"))) {
                    list.remove(j);
                }
            }
        }
    }

    /**
     * 设置EasyPOI导出参数
     *
     * @param fileName 文件名
     * @return 导出参数
     */
    public static ExportParams getExportParams(String fileName) {
        ExportParams exportParams = new ExportParams(null, fileName);
        exportParams.setStyle(EasyPoiStyle.class);
        exportParams.setType(ExcelType.XSSF);
        return exportParams;
    }
    public String gsRequestData(String transcode, String body) {
        return "{\"packet\": "
                + "{\"head\": "
                + "{\"transtype\":\"request\","
                + "\"transdate\":\"" + DateTime.now().toString("yyyMMdd") + "\","
                + "\"transtime\":\"" + DateTime.now().toString("HHmmss") + "\","
                + "\"transcode\":\"" + transcode + "\"},"

                + "\"body\":" + body + "}"
                + "}";
    }

//    /**
//     * ESB请求服务统一封装，发送请求
//     *
//     * @param ServiceID
////     * @param transcode
//     * @param requestStr 请求参数，全部同意JSON字符串方式
//     * @return 返回报文字符串
//     */
//    public JSONObject esbRequest(String ServiceID, String requestStr) {
//        /**
//         * 按照报文格式封装
//         */
//        String requestBody = setEsbReuqstBody(ServiceID, requestStr);
//
//        String responseStr = HttpRequest.post(esbConfigPo.getEsbUrl())
//                .header(Header.CONTENT_TYPE, "application/json;charset=utf-8")//头信息，多个头信息多次调用此方法即可
//                .body(requestBody)//内容
//                .charset("UTF-8")
//                .timeout(60000)//超时，毫秒
//                .execute().body();
//
//        return parseEsbResponse(responseStr);
//    }

    /**
     * 包装浪潮ESB请求体
     *
//     * @param ServiceID 服务编号
//     * @param transcode 浪潮标识
//     * @param body      浪潮请求报文
     * @return
     */
//    public String setEsbReuqstBody(String ServiceID, String requestBody) {
//
//
//        String requestStr = "{\"Service\":"
//                + "{\"Route\":"
//                + "{\"SerialNO\":\"" + UUID.fastUUID() + "\","
//                + "\"ServiceID\":\"" + ServiceID + "\","
//                + "\"ServiceTime\":\"" + DateUtil.format(DateUtil.date(), "yyyyMMddHHmmssSSS") + "\","
//                + "\"SourceSysID\":\"" + esbConfigPo.getSourceSysId() + "\"},"
//                + "\"Data\":"
//                + "{\"Request\":" + requestBody + "}"
//                + "}}";
//        //System.out.println(requestStr);
////        log.info(requestStr);
//        return JSONUtil.toJsonStr(requestStr);
//    }

    //获取ESB返回数据中消息
    public JSONObject parseEsbResponse(String responseStr) {
        try {
            JSONObject jsonobject = JSONUtil.parseObj(responseStr);
            return jsonobject.getJSONObject("Service").getJSONObject("Data").getJSONObject("Response");
        } catch (Exception e) {
//            log.error(e.getLocalizedMessage());
            return JSONUtil.parseObj("{\"msg\":\"" + responseStr + "\"}");
        }

    }

    /**
     * 由后缀名返回文件类型
     *
     * @param suffix
     * @return
     */
    public static Integer handleFileType(String suffix) {
        if ("bmp,jpg,jpeg,png,gif,webp".indexOf(suffix) != -1) {
            return Integer.valueOf(FileTypeEnum.one.getCode());
        }
        if ("docx,doc,xls,xlsx,ppt,pptx,pdf,htl,html,txt".indexOf(suffix) != -1) {
            return Integer.valueOf(FileTypeEnum.two.getCode());
        }
        if ("rar,zip,7z,gz,bz,ace,uha,uda,zpaq".indexOf(suffix) != -1) {
            return Integer.valueOf(FileTypeEnum.three.getCode());
        }
        if ("avi,wmv,mpg,mpeg,mov,rm,ram,swf,flv,mp4".indexOf(suffix) != -1) {
            return Integer.valueOf(FileTypeEnum.four.getCode());
        } else {
            return Integer.valueOf(FileTypeEnum.five.getCode());
        }
    }

}