package com.artfess.cgpt.universal.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.entity.BizModel;
import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@TableName("biz_accessory")
@Data
@ApiModel(value = "Accessory",description = "通用附件表")
public class Accessory extends BizNoModel<Accessory> {
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;
    @TableField("TYPE_")
    @ApiModelProperty(value = "附件类型（使用字典，1：图片，2：文档，3：压缩文件，4：视频，5：其它）")
    private Integer type;
    @TableField("NAME_")
    @ApiModelProperty(value = "附件名")
    private String name;
    @TableField("SOURCE_ID_")
    @ApiModelProperty(value = "对应资源Id")
    private String sourceId;
    @TableField("URL_")
    @ApiModelProperty(value = "访问下载路径")
    private String url;
    @TableField("SUFFIX_")
    @ApiModelProperty(value = "后缀")
    private String suffix;
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;
    @TableField("GROUP_")
    @ApiModelProperty(value = "分组标识")
    private String group;
    @TableField("FILE_SIZE_")
    @ApiModelProperty(value = "文件大小，单位MB")
    private String fileSize;

    @TableField("BID_TYPE_")
    @ApiModelProperty(value = "投标文件类型（1.电子投标，2.线下投标）")
    private Integer bidType;

    @TableField("BID_SIGN_STATUS_")
    @ApiModelProperty(value = "签署状态（1.未签署，2.签署中，3.已完成）")
    private Integer bidSignStatus;

    @TableField("BID_CONTRACT_URL_")
    @ApiModelProperty(value = "签署投标文件URL")
    private String bidContractUrl;

    @TableField("BID_CONTRACT_ID_")
    @ApiModelProperty(value = "签署投标文件ID（电子合同系统）")
    private String bidContractId;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
