package com.artfess.cgpt.universal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.contract.manager.ContractCallBackManager;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.model.Chunk;
import com.artfess.cgpt.universal.service.AccessoryService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

@RestController
@RequestMapping("biz/universal/v1")
@Api(tags = "通用附件管理接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@Slf4j
public class AccessoryController extends BaseController<AccessoryService, Accessory> {

    @Autowired
    private ContractCallBackManager contractCallBackManager;

    @PostMapping("/getBySourceId/{sourceId}")
    @ApiOperation(value = "S-通过资源Id不分页查询附件信息", httpMethod = "Post")
    public CommonResult<List<Accessory>> getBySourceId(@ApiParam(name = "sourceId", value = "资源Id") @PathVariable String sourceId) {
        List<Accessory> result = baseService.getAccessoryBySourceId(sourceId);
        return new CommonResult<List<Accessory>>(true, "操作成功", result);
    }

    @PostMapping("/save")
    @ApiOperation(value = "S-批量保存附件信息", httpMethod = "Post")
    public CommonResult<String> saveAccessory(@ApiParam(name = "accessory", value = "附件对象") @RequestBody List<Accessory> list) {
        boolean status = baseService.saveAccessory(list);
        String msg = status ? "保存成功" : "保存失败";
        return new CommonResult<String>(status, msg);

    }


    @PostMapping("/minIoAllDownFile")
    @ApiOperation(value = "S-通用下载接口", httpMethod = "POST", notes = "通用下载接口")
    public void downTest(@ApiParam(name = "ids", value = "ids", required = true)
                         @RequestParam(value = "ids", required = true) String ids,
                         @ApiParam(name = "bizPath", value = "bizPath", required = true)
                         @RequestParam(value = "bizPath", required = true) String bizPath, HttpServletResponse response) throws Exception {
        baseService.minIoDownFile(ids, bizPath, response);

    }

    @PostMapping("/ShardUpload")
    @ApiOperation(value = "S-大文件分片上传接口", httpMethod = "POST", notes = "大文件分片上传接口（上传完毕需调用合并接口）")
    public CommonResult<String> minioUpload(@RequestBody MultipartFile upFile,@ApiParam(name = "chunk",value = "分片文件对象",required = true)  Chunk chunk, HttpServletResponse response) throws Exception {
        log.info("通用附件管理-附件上传接口请求参数：{}",chunk,response);
        chunk.setFile(upFile);
        String result = baseService.fileUploadPost(chunk, response);
        boolean status = result.equals("over") || result.equals("ok");
        log.info("通用附件管理-附件上传接口响应结果：{}",result);
        return new CommonResult<String>(status, status?"上传成功":"上传失败",result);
    }

    @PostMapping("/mergeFileToMinIO")
    @ApiOperation(value = "S-大文件分片上传合并接口", httpMethod = "POST", notes = "大文件分片上传合并文件异步上传MinIO")
    public CommonResult<Accessory> mergeFileToMinIO(
            @ApiParam(name = "bizPath",value = "MinIO中的业务文件夹",required = true) @RequestParam String bizPath,
            @ApiParam(name = "fileName",value = "文件名",required = true) @RequestParam String fileName) throws Exception {
        log.info("通用附件管理-合并文件异步上传MinIO接口请求参数：{}",bizPath,fileName);
        Accessory accessory = baseService.minioUpload(bizPath, fileName);
        log.info("通用附件管理-合并文件异步上传MinIO接口响应结果：{}",accessory);
        return new CommonResult<Accessory>(true, "上传成功", accessory);
    }

    @RequestMapping("/minioUpload")
    @ApiOperation(value = "普通附件上传接口", httpMethod = "POST", notes = "普通附件上传接口")
    public CommonResult<Accessory> minioUpload(MultipartFile file,String bizPath ,HttpServletResponse response) throws Exception {
        Accessory accessory = this.baseService.minioUpload(file,bizPath, response);
        return new CommonResult<Accessory>(true, "上传成功",accessory);
    }

    @RequestMapping("/minioBatchUpload")
    @ApiOperation(value = "普通附件批量上传接口", httpMethod = "POST", notes = "普通附件上传接口")
    public CommonResult<List<Accessory>> minioBatchUpload(List<MultipartFile> fileList,String bizPath ,HttpServletResponse response) throws Exception {
        List<Accessory> accessoryList = this.baseService.minioBatchUpload(fileList,bizPath, response);
        return new CommonResult<List<Accessory> >(true, "上传成功",accessoryList);
    }


    @PostMapping("/delete")
    @ApiOperation(value = "S-批量删除附件信息", httpMethod = "POST")
    public CommonResult<String> delete(@ApiParam(name = "ids", value = "ID集合") @RequestParam("ids") String ids) throws Exception {
        log.info("通用附件管理-批量删除附件信息接口请求参数：{}", ids);
        Assert.notNull(ids, "主键集合不能为空");
        boolean state = baseService.removeByIds(Arrays.asList(ids.split(",")));
        String msg = state ? "删除成功" : "删除失败";
        log.debug("通用附件管理-批量删除附件信息接口响应结果：{}", msg);
        return new CommonResult<String>(state, msg);
    }


    @PostMapping("/removeBySourceId/{sourceId}")
    @ApiOperation(value = "S-通过资源ID删除附件信息", httpMethod = "POST")
    public CommonResult<String> removeBySourceId(@ApiParam(name = "sourceId", value = "资源ID") @PathVariable String sourceId) throws Exception {
        log.info("通用附件管理-通过资源ID删除附件信息接口请求参数：{}",sourceId);
        boolean status = baseService.removeBySourceId(sourceId);
        String msg = status ? "删除成功" : "删除失败";
        log.info("通用附件管理-通过资源ID删除附件信息响应结果：{}",msg);
        return new CommonResult<String>(true, msg);
    }


    @PostMapping("/getPageBySourceId")
    @ApiOperation(value = "S-通过资源ID分页查询附件信息",notes = "必须传入SOURCE_ID_", httpMethod = "POST")
    public CommonResult<PageList<Accessory>> getPageBySourceId(@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<Accessory> queryFilter){
        log.info("通用附件管理-通过资源ID查询附件信息接口请求参数：{}",queryFilter);
        PageList<Accessory> result = baseService.getAccessoryPageBySourceId(queryFilter);
        log.info("通用附件管理-通过资源ID查询附件信息响应结果：{}",result);
        return new CommonResult<>(true,"操作成功",result);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "contractId", value = "文件编号", dataType = "String"),
            @ApiImplicitParam(name = "sn", value = "文件自定义编号", dataType = "String"),
            @ApiImplicitParam(name = "status", value = "文件状态", dataType = "String"),
            @ApiImplicitParam(name = "type", value = "回调类型", dataType = "String"),
            @ApiImplicitParam(name = "contact", value = "联系方式", dataType = "String"),
            @ApiImplicitParam(name = "operatorName", value = "操作人姓名", dataType = "String"),
            @ApiImplicitParam(name = "operatorMobile", value = "操作人手机号", dataType = "String"),
            @ApiImplicitParam(name = "operatorNumber", value = "操作人员工编号", dataType = "String"),
            @ApiImplicitParam(name = "receiverNumber", value = "经办人员工编号", dataType = "String"),
            @ApiImplicitParam(name = "accessKey", value = "ak", dataType = "String"),
            @ApiImplicitParam(name = "secretKey", value = "sk", dataType = "String"),
    })
    @PostMapping("/signingCompleted")
    @ApiOperation(value = "M-签署完成（合同系统回调接口）")
    public void signingCompleted(String contractId,
                                 String sn, String status,String type, String contact,
                                 String operatorName, String operatorMobile,
                                 String operatorNumber,String receiverNumber,
                                 String accessKey, String secretKey) {
        contractCallBackManager.signingCompleted(contractId,sn,status,type,
                contact,operatorName,operatorMobile,operatorNumber,receiverNumber,
                accessKey,secretKey,2);
    }


}
