package com.artfess.cgpt.supplier.vo;


import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.annotation.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;


@Data
@ApiModel(value="BizSupplierEnterpriseVo对象", description="供应商_企业关联表查询VO")
public class BizSupplierEnterpriseVo extends Org {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(name = "id", notes = "组织id")
    protected String id;

    @ApiModelProperty(value = "供应商ID（org组织ID）")
    private String supplierId;

    @ApiModelProperty(value = "供应商编码（org组织CODE）")
    private String supplierCode;

    @ApiModelProperty(value = "供应商名称")
    protected String supplierName;

    @ApiModelProperty(value = "供应商组织级别")
    protected String supplierGrade;

    @ApiModelProperty(value = "供应商父组织id")
    protected String supplierParentId;

    @ApiModelProperty(value = "组织类型（ogn,dept）")
    protected String supplierOrgKind;

    @ApiModelProperty(value = "维度id")
    protected String supplierDemId;

    @ApiModelProperty(value = "企业ID（关联组织表ID）")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编码")
    private String enterpriseCode;

    @ApiModelProperty(value = "企业名称")
    protected String enterpriseName;

    @ApiModelProperty(value = "企业组织级别")
    protected String enterpriseGrade;

    @ApiModelProperty(value = "企业父组织id")
    protected String enterpriseParentId;

    @ApiModelProperty(value = "组织类型（ogn,dept）")
    protected String enterpriseOrgKind;

    @ApiModelProperty(value = "维度id")
    protected String enterpriseDemId;

    @ApiModelProperty(value = "排序号")
    private Integer sn;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    private String isDele;




    @ApiModelProperty(value = "创建人ID")
    private String createBy;

    @ApiModelProperty(value = "创建人姓名")
    private String createName;

    @ApiModelProperty(value = "创建人部门ID")
    private String createDeptId;

    @ApiModelProperty(value = "创建人部门名称")
    private String createDeptName;

    @ApiModelProperty(value = "创建人组织ID")
    private String createOrgId;

    @ApiModelProperty(value = "创建人组织名称")
    private String createOrgName;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新人ID")
    private String updateBy;

    @ApiModelProperty(value = "更新人姓名")
    private String updateName;

    @ApiModelProperty(value = "更新人部门ID")
    private String updateDeptId;

    @ApiModelProperty(value = "更新人部门名称")
    private String updateDeptName;

    @ApiModelProperty(value = "更新人组织ID")
    private String updateOrgId;

    @ApiModelProperty(value = "更新人组织名称")
    private String updateOrgName;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "最后更新时间戳")
    private Long lastTime;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Integer version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;
}

