package com.artfess.cgpt.supplier.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Description:供应商评价明细表
 * @Author: Rong Tao
 * @Date: 2024/6/20 18:05
 */
@ApiModel(value="SupplierEvaluationDetail对象", description="供应商评价明细表")
@TableName("biz_supplier_evaluation_detail")
@Data
public class SupplierEvaluationDetail extends BizNoModel<SupplierEvaluationDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "供应商评价表ID")
    @TableField("SUPPLIER_EVALUATION_ID_")
    private String supplierEvaluationId;

    @ApiModelProperty(value = "问题清单ID")
    @TableField("ISSUE_MANAGEMENT_ID_")
    private String issueManagementId;

    @ApiModelProperty(value = "供应商分类评级标准ID")
    @TableField("SUPPLIER_TYPE_EVALUATION_ID_")
    private String supplierTypeEvaluationId;

    @ApiModelProperty(value = "评分方（1：企业方，2：运营方）")
    @TableField("EVALUATION_DIMENSION_")
    private Integer evaluationDimension;

    @ApiModelProperty(value = "评分")
    @TableField("SCORE_")
    private Integer score;

    @ApiModelProperty(value = "评分类型（使用字典）")
    @TableField("EVALUATION_TYPE_")
    private Integer evaluationType;

    @ApiModelProperty(value = "评分项目")
    @TableField("EVALUATION_ITEM_")
    private String evaluationItem;

    @ApiModelProperty(value = "评分标准")
    @TableField("EVALUATION_STANDARD_")
    private String evaluationStandard;

    @ApiModelProperty(value = "分值")
    @TableField("EVALUATION_SCORE_")
    private Integer evaluationScore;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

}
