package com.artfess.cgpt.supplier.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 准入供应商资质信息表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@ApiModel(value="BizSupplierOrgQualificationLabel对象", description="准入供应商资质信息表，准入供应商_资质库中间表")
@TableName("biz_supplier_org_qualification_label")
@Data
public class BizSupplierOrgQualificationLabel extends BaseModel<BizSupplierOrgQualificationLabel> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "准入供应商ID（关联准入供应商表ID）")
    @TableField("ADMITTED_SUPPLIER_ID_")
    private String admittedSupplierId;

    @ApiModelProperty(value = "供应商编码")
    @TableField("SUPPLIER_CODE_")
    private String supplierCode;

    @ApiModelProperty(value = "资质库ID（关联资质库表ID）")
    @TableField("QUALIFICATION_LABEL_ID_")
    private String qualificationLabelId;

}
