package com.artfess.cgpt.supplier.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商评价表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-27
 */
@ApiModel(value="BizSupplierEvaluation对象", description="供应商评价表")
@TableName("biz_supplier_evaluation")
@Data
public class BizSupplierEvaluation extends BizModel<BizSupplierEvaluation> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "准入供应商表ID")
    @TableField("ADMITTED_SUPPLIER_ID_")
    private String admittedSupplierId;

    @ApiModelProperty(value = "供应商分类表ID（关联供应商分类表ID）")
    @TableField("SUPPLIER_TYPE_ID_")
    private String supplierTypeId;

    @ApiModelProperty(value = "供应商分类编码")
    @TableField("CATEGORY_CODE_")
    private String categoryCode;

    @ApiModelProperty(value = "供应商分类名称")
    @TableField("CATEGORY_NAME_")
    private String categoryName;

    @ApiModelProperty(value = "供应商表ID（关联供应商表ID）")
    @TableField("SUPPLIER_ID_")
    private String supplierId;

    @ApiModelProperty(value = "供应商编号")
    @TableField("SUPPLIER_CODE_")
    private String supplierCode;

    @ApiModelProperty(value = "供应商名称")
    @TableField("SUPPLIER_NAME_")
    private String supplierName;

    @ApiModelProperty(value = "评分方（1：企业方，2：运营方）")
    @TableField("EVALUATION_DIMENSION_")
    private Integer evaluationDimension;

    @ApiModelProperty(value = "评分企业ID")
    @TableField("SCORE_ORG_ID_")
    private String scoreOrgId;

    @ApiModelProperty(value = "评分企业编号")
    @TableField("SCORE_ORG_CODE_")
    private String scoreOrgCode;

    @ApiModelProperty(value = "评分企业名称")
    @TableField("SCORE_ORG_NAME_")
    private String scoreOrgName;

    @ApiModelProperty(value = "评分人ID")
    @TableField("SCORE_USER_ID_")
    private String scoreUserId;

    @ApiModelProperty(value = "评分人账号")
    @TableField("SCORE_USER_ACCOUNT_")
    private String scoreUserAccount;

    @ApiModelProperty(value = "评分人姓名")
    @TableField("SCORE_USER_NAME_")
    private String scoreUserName;

    @ApiModelProperty(value = "评分（总分）")
    @TableField("SCORE_")
    private Integer score;

    @ApiModelProperty(value = "供应商级别（使用字典，1：A级，2：B级，3：C级，4：D级）")
    @TableField("LEVEL_")
    private String level;

    @ApiModelProperty(value = "评分时间")
    @TableField("SCORE_TIME_")
    private LocalDateTime scoreTime;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "评分明细集合")
    @TableField(exist = false)
    private List<SupplierEvaluationDetail> detailList;

}
