package com.artfess.cgpt.supplier.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.qualification.model.BizQualificationCategory;
import com.artfess.cgpt.supplier.dao.AdmissionConfigQualificationDao;
import com.artfess.cgpt.supplier.manager.AdmissionConfigQualificationManager;
import com.artfess.cgpt.supplier.model.AdmissionConfigQualification;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/7/11 11:08
 */
@Service
public class AdmissionConfigQualificationManagerImpl extends BaseManagerImpl<AdmissionConfigQualificationDao, AdmissionConfigQualification> implements AdmissionConfigQualificationManager {

    @Override
    public PageList<AdmissionConfigQualification> queryByPage(QueryFilter<AdmissionConfigQualification> queryFilter) {
        IPage<AdmissionConfigQualification> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public List<BizQualificationCategory> getQualificationCategoryByConfigId(String configId) {
        return baseMapper.getQualificationCategoryByConfigId(configId);
    }

}
