package com.artfess.cgpt.supplier.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.supplier.model.DataSharing;
import com.artfess.cgpt.supplier.model.Enterprise;

import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/8/6 19:28
 */
public interface DataSharingManager extends BaseManager<DataSharing> {

    /**
     * 分页查询数据
     * @param queryFilter
     * @return
     */
    PageList<DataSharing> queryByPage(QueryFilter<DataSharing> queryFilter);


    /**
     * 保存或更新数据
     * @param entity
     * @return
     */
    void saveOrUpdateEntity(DataSharing entity);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    DataSharing getDataById(String id);

    /**
     * 根据公司查询可共享的数据id
     * @param orgId 公司id
     * @return
     */
    List<String> getBizIdsByOrg(String orgId);


    /**
     * 根据ids删除数据
     * @param ids
     * @return
     */
    void removeByIds(String ids);

}
