package com.artfess.cgpt.supplier.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.qualification.model.BizQualificationCategory;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.supplier.model.AdmissionConfig;
import com.artfess.cgpt.supplier.model.AdmissionConfigQualification;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/7/11 11:07
 */
public interface AdmissionConfigQualificationManager extends BaseManager<AdmissionConfigQualification> {

    /**
     * 分页查询数据
     * @param queryFilter
     * @return
     */
    PageList<AdmissionConfigQualification> queryByPage(QueryFilter<AdmissionConfigQualification> queryFilter);

    /**
     *  根据准入配置id查询资质类型
     * @param configId 准入配置id
     * @return
     */
    List<BizQualificationCategory> getQualificationCategoryByConfigId(String configId);

}
