package com.artfess.cgpt.supplier.dao;

import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.supplier.model.BizSupplierOrg;
import com.artfess.cgpt.supplier.model.BizSupplierOrgQualificationLabel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Param;

/**
 * 供应商资质信息表，供应商_资质库中间表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
public interface BizSupplierOrgQualificationLabelDao extends BaseMapper<BizSupplierOrgQualificationLabel> {

    /**
     * 分页查询所有数据
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizSupplierOrgQualificationLabel> queryAllByPage(IPage<BizSupplierOrgQualificationLabel> convert2IPage, @Param("ew") Wrapper<BizSupplierOrgQualificationLabel> convert2Wrapper);

    /**
     * 分页查询数据
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizQualificationLabel> queryQualificationPage(IPage<BizSupplierOrgQualificationLabel> convert2IPage, @Param("ew")Wrapper<BizSupplierOrgQualificationLabel> convert2Wrapper);

}
