package com.artfess.cgpt.supplier.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.supplier.manager.SupplierIssueManagementDetailManager;
import com.artfess.cgpt.supplier.model.SupplierIssueManagement;
import com.artfess.cgpt.supplier.model.SupplierIssueManagementDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:供应商问题问答记录表
 * @Author: Rong Tao
 * @Date: 2024/7/4 10:59
 */
@RestController
@RequestMapping("/supplierIssueManagementDetail/v1/")
@Api(tags="供应商问题问答记录表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class SupplierIssueManagementDetailController extends BaseController<SupplierIssueManagementDetailManager, SupplierIssueManagementDetail> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<SupplierIssueManagementDetail>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<SupplierIssueManagementDetail> queryFilter){
        PageList<SupplierIssueManagementDetail> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/saveOrUpdateEntity")
    @ApiOperation("保存或更新数据")
    public CommonResult saveOrUpdateEntity(@RequestBody SupplierIssueManagementDetail entity) {
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult(true,"操作成功");
    }

}
