package com.artfess.cgpt.receipt.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizModel;
import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 采购收货单处理记录表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@ApiModel(value="BizReceiptHandle对象", description="采购收货单处理记录表")
@TableName("biz_receipt_handle")
@Data
public class BizReceiptHandle extends BizNoModel<BizReceiptHandle> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "收货单明细ID")
    @TableField("RECEIPT_DETAIL_ID_")
    private String receiptDetailId;

    @ApiModelProperty(value = "收货单明细NAME")
    @TableField(exist = false)
    private String receiptDetailName;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "操作时间")
    @TableField("OPERATER_TIME_")
    private LocalDate operaterTime;

    @ApiModelProperty(value = "原始数量")
    @TableField("OLD_NUM_")
    private BigDecimal oldNum;

    @ApiModelProperty(value = "修改数量")
    @TableField("NUM_")
    private BigDecimal num;

    @ApiModelProperty(value = "操作人ID")
    @TableField("OPERATER_USER_ID_")
    private String operaterUserId;

    @ApiModelProperty(value = "操作人姓名")
    @TableField("OPERATER_USER_NAME_")
    private String operaterUserName;

    @ApiModelProperty(value = "操作人所属公司编号")
    @TableField("OPERATER_COMPANY_CODE_")
    private String operaterCompanyCode;

    @ApiModelProperty(value = "操作人所属公司ID")
    @TableField("OPERATER_COMPANY_ID_")
    private String operaterCompanyId;

    @ApiModelProperty(value = "操作人所属公司名称")
    @TableField("OPERATER_COMPANY_NAME_")
    private String operaterCompanyName;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

}
