package com.artfess.cgpt.receipt.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizModel;
import com.artfess.cgpt.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.RecursiveAction;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 采购收货单表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@ApiModel(value="BizReceipt对象", description="采购收货单表")
@TableName("biz_receipt")
@Data
public class BizReceipt extends BizModel<BizReceipt> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "发货单ID")
    @TableField("ARRIVAL_ID_")
    private String arrivalId;

    @ApiModelProperty(value = "发货单号")
    @TableField("ARRIVAL_CODE_")
    private String arrivalCode;

    @ApiModelProperty(value = "收货单号（自动生成）")
    @TableField("RECEIPT_CODE_")
    private String receiptCode;

    @ApiModelProperty(value = "采购订单ID")
    @TableField("PURCHASE_ORDER_ID_")
    private String purchaseOrderId;

    @ApiModelProperty(value = "采购订单号")
    @TableField("PURCHASE_ORDER_CODE_")
    private String purchaseOrderCode;

    @ApiModelProperty(value = "合同ID，关联合同表ID")
    @TableField("CONTRACT_ID_")
    private String contractId;

    @ApiModelProperty(value = "合同名称")
    @TableField("CONTRACT_NAME_")
    private String contractName;

    @ApiModelProperty(value = "不含税金额")
    @TableField("AMOUNT_")
    private BigDecimal amount;

    @ApiModelProperty(value = "含税金额")
    @TableField("TOTAL_AMOUNT_")
    private BigDecimal totalAmount;

    @ApiModelProperty(value = "发货人ID")
    @TableField("VENDOR_USER_ID_")
    private String vendorUserId;

    @ApiModelProperty(value = "发货人姓名")
    @TableField("VENDOR_USER_NAME_")
    private String vendorUserName;

    @ApiModelProperty(value = "发货人联系方式")
    @TableField("VENDOR_PHONE_")
    private String vendorPhone;

    @ApiModelProperty(value = "发货人所属公司ID")
    @TableField("VENDOR_ID_")
    private String vendorId;

    @ApiModelProperty(value = "发货人所属公司编码")
    @TableField("VENDOR_CODE_")
    private String vendorCode;

    @ApiModelProperty(value = "发货人所属公司名称")
    @TableField("VENDOR_NAME_")
    private String vendorName;

    @ApiModelProperty(value = "收货地址")
    @TableField("UNLOAD_ADDRESS_")
    private String unloadAddress;

    @ApiModelProperty(value = "收货人ID（收货确认时填入）")
    @TableField("MAT_USER_ID_")
    private String matUserId;

    @ApiModelProperty(value = "收货人姓名（收货确认时填入）")
    @TableField("MAT_USER_NAME_")
    private String matUserName;

    @ApiModelProperty(value = "收货人联系方式")
    @TableField("MAT_USER_PHONE_")
    private String matUserPhone;

    @ApiModelProperty(value = "收货人所属公司ID")
    @TableField("MAT_COMPANY_ID_")
    private String matCompanyId;

    @ApiModelProperty(value = "收货人所属公司编码")
    @TableField("MAT_COMPANY_CODE_")
    private String matCompanyCode;

    @ApiModelProperty(value = "收货人所属公司名称")
    @TableField("MAT_COMPANY_NAME_")
    private String matCompanyName;

    @ApiModelProperty(value = "收货时间")
    @TableField("RECEIPT_DATE_")
    private LocalDateTime receiptDate;

    @ApiModelProperty(value = "状态（1：已收货，2：已对账）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "明细集合")
    @TableField(exist = false)
    private List<BizReceiptDetail> detailList;

    @ApiModelProperty(value = "附件集合")
    @TableField(exist = false)
    private List<Accessory> accessoryList;

}
