package com.artfess.cgpt.purchasing.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * @Description:采购审批规则管理
 * @Author: Rong Tao
 * @Date: 2024/5/21 10:29
 */
@ApiModel(value="purchasingRules对象", description="采购审批规则管理")
@TableName("biz_purchasing_rules")
@Data
public class PurchasingRules extends BizModel<PurchasingRules> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "采购公司ID")
    @TableField("PROCURE_ORG_ID_")
    private String procureOrgId;

    @ApiModelProperty(value = "采购公司编码")
    @TableField("PROCURE_ORG_CODE_")
    private String procureOrgCode;

    @ApiModelProperty(value = "采购公司名称")
    @TableField("PROCURE_ORG_NAME_")
    private String procureOrgName;

    @ApiModelProperty(value = "审批规则（1.流程审批，2.跳过审批），默认2")
    @TableField("APPROVAL_RULES_")
    private Integer approvalRules;

//    @ApiModelProperty(value = "审批菜单别名")
//    @TableField("APPROVAL_MENU_ALIAS_")
//    private String approvalMenuAlias;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "菜单别名集合")
    @TableField(exist = false)
    private List<PurchasingRulesDetail> purchasingRulesDetailList;

}