package com.artfess.cgpt.purchasing.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;

/**
 * @Description:采购立项_资质标签关联表
 * @Author: Rong Tao
 * @Date: 2024/6/25 16:09
 */
@ApiModel(value="MatApprovalQualification对象", description="采购立项_资质标签关联表")
@TableName("biz_mat_approval_qualification")
@Data
public class MatApprovalQualification extends BizNoModel<MatApprovalQualification> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "采购立项ID")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "资质标签ID（关联资质类型表id）")
    @TableField("QUALIFICATION_LABEL_ID_")
    private String qualificationLabelId;

    @ApiModelProperty(value = "资质类别编码")
    @TableField("QUALIFICATION_TYPE_VALUE_")
    private String qualificationTypeValue;

    @ApiModelProperty(value = "资质类别名称")
    @TableField("QUALIFICATION_TYPE_NAME_")
    private String qualificationTypeName;

    @ApiModelProperty(value = "限制文件大小（MB），空或者0表示不限制")
    @TableField("FILE_SIZE_")
    private Integer fileSize;

    @ApiModelProperty(value = "限制文件数量，空或者0表示不限制")
    @TableField("FILE_NUM_")
    private Integer fileNum;

    @ApiModelProperty(value = "是否限制有效期（0：不限制，1：限制）")
    @TableField("LIMITATION_")
    private String limitation;

    @ApiModelProperty(value = "到期处理方式（0：冻结，1：提醒）")
    @TableField("EXPIRATION_PROCESSING_METHOD_")
    private String expirationProcessingMethod;

    @ApiModelProperty(value = "是否需要审批（0：不需要审批，1：需要审批）")
    @TableField("CHANGE_APPROVAL_")
    private String changeApproval;

    @ApiModelProperty(value = "审批方式（0：企业审批，1：平台审批）")
    @TableField("CHANGE_APPROVAL_METHOD_")
    private String changeApprovalMethod;

    @ApiModelProperty(value = "描述")
    @TableField("DESCRIBE_")
    private String describe;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

}
