package com.artfess.cgpt.purchasing.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.purchasing.dao.PurchasingRulesDao;
import com.artfess.cgpt.purchasing.manager.PurchasingRulesDetailManager;
import com.artfess.cgpt.purchasing.manager.PurchasingRulesManager;
import com.artfess.cgpt.purchasing.model.PurchasingRules;
import com.artfess.cgpt.purchasing.model.PurchasingRulesDetail;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/5/21 10:36
 */
@Service
public class PurchasingRulesManagerImpl extends BaseManagerImpl<PurchasingRulesDao, PurchasingRules> implements PurchasingRulesManager {

    @Autowired
    private PurchasingRulesDetailManager rulesDetailManager;

    @Override
    public PageList<PurchasingRules> queryAllByPage(QueryFilter<PurchasingRules> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        IPage<PurchasingRules> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public PurchasingRules getDetailById(String id) {
        PurchasingRules result = super.getById(id);
        LambdaQueryWrapper<PurchasingRulesDetail> rulesDetailQW = new LambdaQueryWrapper<>();
        rulesDetailQW.eq(PurchasingRulesDetail::getPurchasingRulesId,id);
        result.setPurchasingRulesDetailList(rulesDetailManager.list(rulesDetailQW));
        return result;
    }

    //2024-07-22 14:50
//    @Override
//    public void saveOrUpdateEntity(PurchasingRules entity) {
//        if(BeanUtils.isEmpty(entity.getId())){
//            //新增
//            //1.查询该公司是否存在数据
//            LambdaQueryWrapper<PurchasingRules> ruleQW = new LambdaQueryWrapper<>();
//            ruleQW.eq(PurchasingRules::getProcureOrgId,entity.getProcureOrgId())
//                    .eq(PurchasingRules::getIsDele,"0")
//                    .last("limit 1");
//            PurchasingRules rules = baseMapper.selectOne(ruleQW);
//
//            if(BeanUtils.isEmpty(rules)){
//                //2.1.如果不存在：保存数据
//                super.save(entity);
//            }else {
//                //2.2.如果存在
//                List<String> newMenuList = Arrays.asList(entity.getApprovalMenuAlias().split(","));
//                List<String> menuHis = new ArrayList<>();
//                //判断是否包含所选菜单
//                if(BeanUtils.isNotEmpty(rules.getApprovalMenuAlias())){
//                    menuHis.addAll(Arrays.asList(rules.getApprovalMenuAlias().split(",")));
//                    for(String menu : newMenuList){
//                        if(!menuHis.contains(menu)){
//                            menuHis.add(menu);
//                        }
//                    }
//                }else {
//                    menuHis = newMenuList;
//                }
//                rules.setApprovalMenuAlias(String.join(",",menuHis));
//                super.updateById(rules);
//            }
//        }else {
//            //更新
//            super.updateById(entity);
//        }
//
//    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(PurchasingRules entity) {
        List<PurchasingRulesDetail> rulesDetailList = entity.getPurchasingRulesDetailList();
        if(BeanUtils.isEmpty(entity.getId())){
            //新增
            //1.查询该公司是否存在数据
            LambdaQueryWrapper<PurchasingRules> ruleQW = new LambdaQueryWrapper<>();
            ruleQW.eq(PurchasingRules::getProcureOrgId,entity.getProcureOrgId())
                    .eq(PurchasingRules::getIsDele,"0")
                    .last("limit 1");
            PurchasingRules rules = baseMapper.selectOne(ruleQW);

            if(BeanUtils.isNotEmpty(rules)){
                entity.setId(rules.getId());
            }
        }

        if(BeanUtils.isNotEmpty(entity.getId())){
            //清除原有菜单别名明细
            LambdaQueryWrapper<PurchasingRulesDetail> rulesDetailQW = new LambdaQueryWrapper<>();
            rulesDetailQW.eq(PurchasingRulesDetail::getPurchasingRulesId,entity.getId());
            rulesDetailManager.remove(rulesDetailQW);
        }

        super.saveOrUpdate(entity);

        if(BeanUtils.isNotEmpty(rulesDetailList) && rulesDetailList.size()>0){
            rulesDetailList.forEach(s->s.setPurchasingRulesId(entity.getId()));
            rulesDetailManager.saveBatch(rulesDetailList);
        }

    }

    @Override
    @Transactional
    public void removeDataByIds(List<String> ids) {
        LambdaQueryWrapper<PurchasingRulesDetail> rulesDetailQW = new LambdaQueryWrapper<>();
        rulesDetailQW.in(PurchasingRulesDetail::getPurchasingRulesId,ids);
        rulesDetailManager.remove(rulesDetailQW);
        super.removeByIds(ids);
    }

    @Override
    public Boolean isAuditing(String orgId, String menuAlia) {
        return null;
    }

}
