package com.artfess.cgpt.purchasing.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.purchasing.model.PurchasingApplication;
import com.artfess.cgpt.purchasing.model.MatApproval;

import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/3/26 9:43
 */
public interface MatApprovalManager extends BaseManager<MatApproval> {

    /**
     * 根据id查询数据（不加租户过滤）
     * @param id
     * @return
     */
    MatApproval getByIdNoTenantId(String id);

    /**
     * 分页查询数据（组织公司过滤）
     * @param queryFilter
     * @return
     */
    PageList<MatApproval> queryByPage(QueryFilter<MatApproval> queryFilter);

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<MatApproval> queryAllByPage(QueryFilter<MatApproval> queryFilter);

    /**
     * 根据id集合删除数据
     * @param ids
     */
    void removeByIds(List<String> ids);

    /**
     * 保存或更新数据
     * @param entity
     * @return 数据id
     */
    MatApproval saveOrUpdateEntity(MatApproval entity);

    /**
     * 上传补遗文件
     * @param entity
     */
    void uploadTenderDoc(MatApproval entity);

    /**
     * 修改项目状态
     * @param ids
     * @param status
     */
    void modifyBidStatus(String ids,String status);

    /**
     * 修改发布状态
     * @param ids
     * @param status
     */
    void modifyReleaseStatus(String ids,String status);

    /**
     * 修改定标状态
     * @param ids
     * @param status
     */
    void modifyCalibraStatus(String ids,String status);

    /**
     * 修改成交公示发布状态
     * @param ids
     * @param status
     */
    void modifyPublicityStatus(String ids,String status);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    MatApproval getDataById(String id);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    MatApproval getReleaseDataById(String id);

    /**
     * 参与报名-立项分页查询
     * @param queryFilter
     * @return
     */
    PageList<MatApproval> signData(QueryFilter<MatApproval> queryFilter);

    /**
     * 根据id查询详情（公告及相关文件）
     * @param id
     * @return
     */
    MatApproval getInfoById(String id);

    /**
     * 根据id和用户查询详情（公告及相关文件）
     * @param id
     * @param userId
     * @return
     */
    MatApproval getInfoByIdAndUserId(String id,String userId);

    /**
     * 我的报价-分页查询
     * @param queryFilter
     * @return
     */
    PageList<MatApproval> quoData(QueryFilter<MatApproval> queryFilter);

    /**
     * 报价管理-分页查询
     * @param queryFilter
     * @return
     */
    PageList<MatApproval> quoManageData(QueryFilter<MatApproval> queryFilter);

    /**
     * 开标管理-分页查询
     * @param queryFilter
     * @return
     */
    PageList<MatApproval> bidOpenData(QueryFilter<MatApproval> queryFilter);

    /**
     * 开标管理-开标
     * @param entity
     */
    void openingBid(MatApproval entity);

    /**
     * 开标管理-发起新一轮报价
     * @param entity
     */
    void newRoundQuo(MatApproval entity);

    /**
     * 评标管理-分页查询
     * @param queryFilter
     * @return
     */
    PageList<MatApproval> bidEvaData(QueryFilter<MatApproval> queryFilter);

    /**
     * 成交通知-发布
     * @param id
     * @return
     */
    void releaseWinBidNotice(String id) throws Exception;

    /**
     * 评标查看-分页查询
     * @param queryFilter
     * @return
     */
    PageList<MatApproval> bidEvaAgencyData(QueryFilter<MatApproval> queryFilter);

    /**
     * 评标查看-根据立项id获取立项类型
     * @param id 立项id
     * @return 立项类型
     */
    Integer getNoticeTypeById(String id);

}
