package com.artfess.cgpt.purchasing.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.model.PurchasingApplication;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.supplier.manager.DataSharingManager;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.dataAccess.manager.DataAccessDefinedManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/3/26 9:48
 */
@RestController
@RequestMapping("/matApproval/v1/")
@Api(tags="物料采购立项表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class MatApprovalController extends BaseController<MatApprovalManager, MatApproval> {

    @Autowired
    private DataSharingManager dataSharingManager;

    @PostMapping("/pageDataSharinhg")
    @ApiOperation(value = "M-分页查询数据（包含共享数据）")
    public CommonResult<PageList<MatApproval>> pageDataSharinhg(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<MatApproval> queryFilter) {
        if(BeanUtils.isEmpty(ContextUtil.getCurrentOrgId())){
            return new CommonResult<>(true, "查询成功", new PageList<>(new ArrayList<MatApproval>()));
        }

        //查询当前组织可共享的立项id
        List<String> bizIds = dataSharingManager.getBizIdsByOrg(ContextUtil.getCurrentOrgId());

        if(BeanUtils.isNotEmpty(bizIds) && bizIds.size()>0){
            queryFilter.addFilter("ID_", bizIds, QueryOP.IN, FieldRelation.OR,"orgQuery");
        }

        PageList<MatApproval> result = baseService.queryByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据（组织公司过滤）")
    public CommonResult<PageList<MatApproval>> queryByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<MatApproval> queryFilter) {
        PageList<MatApproval> result = baseService.queryByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/pageCurUser")
    @ApiOperation(value = "M-分页查询数据（当前用户为立项人的）")
    public CommonResult<PageList<MatApproval>> pageCurUser(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<MatApproval> queryFilter) {
        queryFilter.addFilter("AFFILIATED_USER_ID_", ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        PageList<MatApproval> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/pageWinNoticeCurUser")
    @ApiOperation(value = "M-分页查询成交立项数据（当前用户为立项人的）")
    public CommonResult<PageList<MatApproval>> pageWinNoticeCurUser(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<MatApproval> queryFilter) {
        queryFilter.addFilter("AFFILIATED_USER_ID_", ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        PageList<MatApproval> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/pageAll")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<MatApproval>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<MatApproval> queryFilter) {
        PageList<MatApproval> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/removeByIds")
    @ApiOperation(value = "M-根据id集合删除数据")
    public CommonResult removeByIds(@RequestBody List<String> ids) {
        baseService.removeByIds(ids);
        return new CommonResult<>(true, "删除成功");
    }

    @PostMapping("/saveOrUpdate")
    @ApiOperation(value = "M-保存或更新数据")
    public CommonResult saveOrUpdate(@RequestBody MatApproval entity){
        MatApproval result = baseService.saveOrUpdateEntity(entity);
        return new CommonResult<>(true,"操作成功",result);
    }

    @PostMapping("/uploadTenderDoc")
    @ApiOperation(value = "M-上传补遗文件")
    public CommonResult uploadTenderDoc(@RequestBody MatApproval entity){
        baseService.uploadTenderDoc(entity);
        return new CommonResult<>(true,"操作成功");
    }

    @PostMapping("/modifyBidStatus")
    @ApiOperation(value = "M-修改项目状态")
    public CommonResult modifyBidStatus(@RequestParam("ids") String ids,
                                        @RequestParam("status") String status){
        baseService.modifyBidStatus(ids,status);
        return new CommonResult<>(true,"操作成功");
    }

    @PostMapping("/modifyReleaseStatus")
    @ApiOperation(value = "M-修改发布状态")
    public CommonResult modifyReleaseStatus(@RequestParam("ids") String ids,
                                        @RequestParam("status") String status){
        baseService.modifyReleaseStatus(ids,status);
        return new CommonResult<>(true,"操作成功",ids);
    }

    @PostMapping("/modifyCalibraStatus")
    @ApiOperation(value = "M-修改定标状态")
    public CommonResult modifyCalibraStatus(@RequestParam("ids") String ids,
                                        @RequestParam("status") String status){
        baseService.modifyCalibraStatus(ids,status);
        return new CommonResult<>(true,"操作成功",ids);
    }

    @PostMapping("/modifyPublicityStatus")
    @ApiOperation(value = "M-修改成交公示发布状态")
    public CommonResult modifyPublicityStatus(@RequestParam("ids") String ids,
                                            @RequestParam("status") String status){
        baseService.modifyPublicityStatus(ids,status);
        return new CommonResult<>(true,"操作成功",ids);
    }

    @PostMapping("/getDataById")
    @ApiOperation(value = "M-根据id查询详情")
    public CommonResult<MatApproval> getDataById(@RequestParam("id") String id) {
        MatApproval result = baseService.getDataById(id);
        return new CommonResult<>(true, "查询成功",result);
    }

    @PostMapping("/getReleaseDataById")
    @ApiOperation(value = "M-根据id查询详情（已发布的补遗文件）")
    public CommonResult<MatApproval> getReleaseDataById(@RequestParam("id") String id) {
        MatApproval result = baseService.getReleaseDataById(id);
        return new CommonResult<>(true, "查询成功",result);
    }

    @PostMapping("/signData")
    @ApiOperation(value = "M-参与报名-立项分页查询", notes = "参数说明：通用查询器", httpMethod = "POST")
    public CommonResult<PageList<MatApproval>> signData(@ApiParam(name = "queryFilter", value = "通用查询器") @RequestBody QueryFilter<MatApproval> queryFilter) {
        PageList<MatApproval> result = baseService.signData(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/getInfoById")
    @ApiOperation(value = "M-根据id查询详情（公告及相关文件）")
    public CommonResult<MatApproval> getInfoById(@RequestParam("id") String id) {
        MatApproval result = baseService.getInfoById(id);
        return new CommonResult<>(true, "查询成功",result);
    }

    @PostMapping("/getInfoByIdAndUserId")
    @ApiOperation(value = "M-根据id和用户查询详情（公告及相关文件）")
    public CommonResult<MatApproval> getInfoByIdAndUserId(@RequestParam("id") String id,@RequestParam("userId") String userId) {
        MatApproval result = baseService.getInfoByIdAndUserId(id,userId);
        return new CommonResult<>(true, "查询成功",result);
    }

    @PostMapping("/quoData")
    @ApiOperation(value = "M-我的报价-分页查询", notes = "参数说明：通用查询器", httpMethod = "POST")
    public CommonResult<PageList<MatApproval>> quoData(@ApiParam(name = "queryFilter", value = "通用查询器") @RequestBody QueryFilter<MatApproval> queryFilter) {
        PageList<MatApproval> result = baseService.quoData(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/quoManageData")
    @ApiOperation(value = "M-报价管理-分页查询", notes = "参数说明：通用查询器", httpMethod = "POST")
    public CommonResult<PageList<MatApproval>> quoManageData(@ApiParam(name = "queryFilter", value = "通用查询器") @RequestBody QueryFilter<MatApproval> queryFilter) {
        PageList<MatApproval> result = baseService.quoManageData(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/bidOpenData")
    @ApiOperation(value = "M-开标管理-分页查询", notes = "参数说明：通用查询器", httpMethod = "POST")
    public CommonResult<PageList<MatApproval>> bidOpenData(@ApiParam(name = "queryFilter", value = "通用查询器") @RequestBody QueryFilter<MatApproval> queryFilter) {
        PageList<MatApproval> result = baseService.bidOpenData(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/openingBid")
    @ApiOperation(value = "M-开标管理-开标")
    public CommonResult openingBid(@RequestBody MatApproval entity){
        baseService.openingBid(entity);
        return new CommonResult<>(true,"操作成功");
    }

    @PostMapping("/newRoundQuo")
    @ApiOperation(value = "M-开标管理-发起新一轮报价")
    public CommonResult newRoundQuo(@RequestBody MatApproval entity){
        baseService.newRoundQuo(entity);
        return new CommonResult<>(true,"操作成功");
    }

    @PostMapping("/bidEvaData")
    @ApiOperation(value = "M-评标管理-分页查询", notes = "参数说明：通用查询器", httpMethod = "POST")
    public CommonResult<PageList<MatApproval>> bidEvaData(@ApiParam(name = "queryFilter", value = "通用查询器") @RequestBody QueryFilter<MatApproval> queryFilter) {
        PageList<MatApproval> result = baseService.bidEvaData(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/releaseWinBidNotice")
    @ApiOperation(value = "M-成交通知-发布", notes = "", httpMethod = "POST")
    public CommonResult releaseWinBidNotice(@RequestParam("id") String id) throws Exception {
        baseService.releaseWinBidNotice(id);
        return new CommonResult<>(true, "操作成功");
    }

    @PostMapping("/bidEvaAgencyData")
    @ApiOperation(value = "M-评标查看-分页查询", notes = "参数说明：通用查询器", httpMethod = "POST")
    public CommonResult<PageList<MatApproval>> bidEvaAgencyData(@ApiParam(name = "queryFilter", value = "通用查询器") @RequestBody QueryFilter<MatApproval> queryFilter) {
        PageList<MatApproval> result = baseService.bidEvaAgencyData(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/getNoticeTypeById")
    @ApiOperation(value = "M-根据立项id获取立项类型", notes = "参数说明：通用查询器", httpMethod = "POST")
    public CommonResult getNoticeTypeById(@RequestParam("id") String id) {
        Integer result = baseService.getNoticeTypeById(id);
        return new CommonResult<>(true, "查询成功", result);
    }

}
