package com.artfess.cgpt.purchasing.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.purchasing.manager.BizPurchaseOrderDetailManager;
import com.artfess.cgpt.purchasing.model.BizPurchaseOrderDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 采购订单明细表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-27
 */

@RestController
@RequestMapping("/bizPurchaseOrderDetail/v1/")
@Api(tags = "采购订单明细表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizPurchaseOrderDetailController extends BaseController<BizPurchaseOrderDetailManager, BizPurchaseOrderDetail> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<BizPurchaseOrderDetail>> queryAllByPage(@ApiParam(name="queryFilter",value = "通用查询器")@RequestBody QueryFilter<BizPurchaseOrderDetail> queryFilter){
        PageList<BizPurchaseOrderDetail> result=baseService.query(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "S-查询详情")
    public CommonResult<BizPurchaseOrderDetail> selectOne(@RequestParam("id") String id){
        BizPurchaseOrderDetail result=baseService.get(id);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除")
    public CommonResult remove(@RequestBody List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/save")
    @ApiOperation(value = "S-添加或修改")
    public CommonResult save(@RequestBody BizPurchaseOrderDetail entity) {
        String message = "操作成功";
        baseService.save(entity);
        return new CommonResult<>(true, message);
    }




}
