package com.artfess.cgpt.project.dao;

import com.artfess.cgpt.project.model.ProjectInfo;
import com.artfess.cgpt.project.model.UserParticipation;
import com.baomidou.mybatisplus.annotation.SqlParser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 参与报名表Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
public interface UserParticipationDao extends BaseMapper<UserParticipation> {

    IPage<UserParticipation> queryAllByPage(IPage<UserParticipation> convert2IPage, @Param("ew") Wrapper<UserParticipation> convert2Wrapper);

    @SqlParser(filter=true)
    List<UserParticipation> queryList(@Param("ew") Wrapper<UserParticipation> wrapper);

    /**
     * 获取成交未退款数据
     * @return
     */
    List<UserParticipation> getNoRefundData();

}
