package com.artfess.cgpt.project.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.project.manager.UserParticipationQualificationLabelManager;
import com.artfess.cgpt.project.model.UserParticipation;
import com.artfess.cgpt.project.model.UserParticipationQualificationLabel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:参与报名资质信息关联表
 * @Author: Rong Tao
 * @Date: 2024/7/2 10:03
 */
@Api(tags="参与报名资质信息关联表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RestController
@RequestMapping("/userParticipationQualificationLabel/v1/")
public class UserParticipationQualificationLabelController extends BaseController<UserParticipationQualificationLabelManager, UserParticipationQualificationLabel> {

    @PostMapping("/pageAll")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<UserParticipationQualificationLabel>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<UserParticipationQualificationLabel> queryFilter) {
        PageList<UserParticipationQualificationLabel> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

}
