package com.artfess.cgpt.project.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.project.manager.EngineeringProjectDetailManager;
import com.artfess.cgpt.project.manager.ServiceProjectDetailManager;
import com.artfess.cgpt.project.model.ServiceProjectDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:服务项目明细表
 * @Author: Rong Tao
 * @Date: 2024/5/24 15:56
 */
@RestController
@RequestMapping("/serviceProjectDetail/v1/")
@Api(tags="服务项目明细表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ServiceProjectDetailController extends BaseController<ServiceProjectDetailManager, ServiceProjectDetail> {

    @PostMapping("/pageAll")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<ServiceProjectDetail>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<ServiceProjectDetail> queryFilter) {
        PageList<ServiceProjectDetail> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

}
