package com.artfess.cgpt.out.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 销售单明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@ApiModel(value="BizOutManifestDetailedNew对象", description="销售单明细表")
public class BizOutManifestDetailedNew extends BaseModel<BizOutManifestDetailedNew> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableField("ID_")
    private String id;

    @ApiModelProperty(value = "发货人ID")
    @TableField("OUT_MANIFEST_USER_ID_")
    private String outManifestUserId;

    @ApiModelProperty(value = "发货人姓名")
    @TableField("OUT_MANIFEST_USER_NAME_")
    private String outManifestUserName;

    @ApiModelProperty(value = "发货人联系方式")
    @TableField("OUT_MANIFEST_USER_PHONE_")
    private String outManifestUserPhone;

    @ApiModelProperty(value = "发货人所属公司ID")
    @TableField("OUT_MANIFEST_COMPANY_ID_")
    private String outManifestCompanyId;

    @ApiModelProperty(value = "发货人所属公司名称")
    @TableField("OUT_MANIFEST_COMPANY_NAME_")
    private String outManifestCompanyName;

    @ApiModelProperty(value = "发货时间")
    @TableField("OUT_MANIFEST_DATE_")
    private LocalDate outManifestDate;

    @ApiModelProperty(value = "发货地址")
    @TableField("OUT_MANIFEST_ADDRESS_")
    private String outManifestAddress;

    @ApiModelProperty(value = "出货单ID")
    @TableField("BIZ_OUT_MANIFEST_ID_")
    private String bizOutManifestId;

    @ApiModelProperty(value = "结算单号，勾选开票后该批次全部设为统一的结算单号，并且生成一条服务费的支付记录")
    @TableField("SETTLEMENT_NUM_")
    private String settlementNum;

    @ApiModelProperty(value = "发货数量")
    @TableField("OUT_MANIFEST_AMOUNT_")
    private BigDecimal outManifestAmount;

    @ApiModelProperty(value = "收货时间")
    @TableField("IN_MANIFEST_DATE_")
    private LocalDate inManifestDate;

    @ApiModelProperty(value = "发票状态，使用字典（1：未开票，2：开票中，3：已开票，4：不能开票）")
    @TableField("INVOICE_STATUS_")
    private Integer invoiceStatus;

    @ApiModelProperty(value = "收货状态（1：未收货 ，2：已收货）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "关联合同表合同ID")
    @TableField("CONTRACT_ID_")
    private String contractId;

    @ApiModelProperty(value = "合同明细ID，关联合同明细ID")
    @TableField("CONTRACT_ITEM_ID_")
    private String contractItemId;

    @ApiModelProperty(value = "竞价立项ID")
    @TableField("HANDLE_NOTICE_ID_")
    private String handleNoticeId;

    @ApiModelProperty(value = "竞价立项明细ID，关联竞价立项明细表ID")
    @TableField("HANDLE_NOTICE_DETAILED_ID_")
    private String handleNoticeDetailedId;

    @ApiModelProperty(value = "物料分类ID，（关联物料分类ID）")
    @TableField("MAT_CATEGORY_ID_")
    private String matCategoryId;

    @ApiModelProperty(value = "物料分类NAME，（关联物料分类名称）")
    @TableField("MAT_CATEGORY_NAME_")
    private String matCategoryName;

    @ApiModelProperty(value = "竞价申请ID（关联竞价申请表ID）")
    @TableField("HANDLE_DETAILED_ID_")
    private String handleDetailedId;

    @ApiModelProperty(value = "物料ID，（关联企业物料表id）")
    @TableField("MAT_ID_")
    private String matId;

    @ApiModelProperty(value = "平台物料编号")
    @TableField("MAT_PLATCODE_")
    private String matPlatcode;

    @ApiModelProperty(value = "物料对应NAME,（关联物料表名称）")
    @TableField("MAT_NAME_")
    private String matName;

    @ApiModelProperty(value = "物料牌号")
    @TableField("MAT_MATERIAL_")
    private String matMaterial;

    @ApiModelProperty(value = "规格型号")
    @TableField("MAT_SPEC_")
    private String matSpec;

    @ApiModelProperty(value = "计量单位")
    @TableField("MAT_UNIT_")
    private String matUnit;

    @ApiModelProperty(value = "基础扩展")
    @TableField("MAT_BASE_EXT_")
    private String matBaseExt;

    @ApiModelProperty(value = "地址")
    @TableField("MAT_OTHER_EXT_")
    private String matOtherExt;

    @ApiModelProperty(value = "品牌")
    @TableField("MAT_BRAND_")
    private String matBrand;

    @ApiModelProperty(value = "购买时间（车辆处理）/ 注册登记日期(闲置设备)")
    @TableField("BUY_DATE_")
    private String buyDate;

    @ApiModelProperty(value = "检验有效期至（车辆处理）")
    @TableField("INSURANCE_PERIOD_END_")
    private String insurancePeriodEnd;

    @ApiModelProperty(value = "排量（车辆处理）")
    @TableField("DISPLACEMENT_")
    private String displacement;

    @ApiModelProperty(value = "保险期至（车辆处理）")
    @TableField("INSPECTION_VALIDITY_")
    private String inspectionValidity;

    @ApiModelProperty(value = "原值")
    @TableField("ORIGINAL_VALUE_")
    private String originalValue;

    @ApiModelProperty(value = "数量（默认值：1）")
    @TableField("NUM_")
    private Double num;

    @ApiModelProperty(value = "含税竞价底价（单位：元）")
    @TableField("BASE_PRICE_")
    private BigDecimal basePrice;

    @ApiModelProperty(value = "税率（百分比）")
    @TableField("TAX_RATE_")
    private Double taxRate;

    @ApiModelProperty(value = "拍卖方式（使用字典，1：物料报价，2：标包报价）")
    @TableField("AUCTION_METHOD_")
    private Integer auctionMethod;

    @ApiModelProperty(value = "竞拍成交价格")
    @TableField("TRANSACTION_PRICE_")
    private BigDecimal transactionPrice;

    @ApiModelProperty(value = "竞拍最高价格")
    @TableField("BIDDING_MAX_PRICE_")
    private BigDecimal biddingMaxPrice;

    @ApiModelProperty(value = "保证金（单位：元）")
    @TableField("BOND_")
    private BigDecimal bond;

    @ApiModelProperty(value = "竞得人报价排名")
    @TableField("WINNER_USER_RANKING_")
    private Integer winnerUserRanking;

    @ApiModelProperty(value = "交易服务费（单位：百分比）")
    @TableField("TRANSACTION_SERVICE_FEE_")
    private BigDecimal transactionServiceFee;

    @ApiModelProperty(value = "有无资质要求（1：无，2：有）")
    @TableField("HAS_QUALIFICATIONS_")
    private Integer hasQualifications;

    @ApiModelProperty(value = "收货人ID（收货确认时填入）")
    @TableField("IN_MANIFEST_USER_ID_")
    private String inManifestUserId;

    @ApiModelProperty(value = "收货人姓名（收货确认时填入）")
    @TableField("IN_MANIFEST_USER_NAME_")
    private String inManifestUserName;

    @ApiModelProperty(value = "收货人联系方式")
    @TableField("IN_MANIFEST_USER_PHONE_")
    private String inManifestUserPhone;

    @ApiModelProperty(value = "收货人所属公司ID")
    @TableField("IN_MANIFEST_COMPANY_ID_")
    private String inManifestCompanyId;

    @ApiModelProperty(value = "收货人所属公司名称")
    @TableField("IN_MANIFEST_COMPANY_NAME_")
    private String inManifestCompanyName;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "创建人ID")
    @TableField("CREATE_BY_")
    private String createBy;

    @ApiModelProperty(value = "创建人姓名")
    @TableField("CREATE_NAME_")
    private String createName;

    @ApiModelProperty(value = "创建人组织名称")
    @TableField("CREATE_ORG_NAME_")
    private String createOrgName;

    @ApiModelProperty(value = "创建人单位ID")
    @TableField("CREATE_COMPANY_ID_")
    private String createCompanyId;

    @ApiModelProperty(value = "创建人单位名称")
    @TableField("CREATE_COMPANY_NAME_")
    private String createCompanyName;

    @ApiModelProperty(value = "创建人组织ID")
    @TableField("CREATE_ORG_ID_")
    private String createOrgId;

    @ApiModelProperty(value = "创建时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新人ID")
    @TableField("UPDATE_BY_")
    private String updateBy;

    @ApiModelProperty(value = "更新人姓名")
    @TableField("UPDATE_NAME_")
    private String updateName;

    @ApiModelProperty(value = "更新人单位名称")
    @TableField("UPDATE_COMPANY_NAME_")
    private String updateCompanyName;

    @ApiModelProperty(value = "更新人单位ID")
    @TableField("UPDATE_COMPANY_ID_")
    private String updateCompanyId;

    @ApiModelProperty(value = "更新人组织ID")
    @TableField("UPDATE_ORG_ID_")
    private String updateOrgId;

    @ApiModelProperty(value = "更新人组织名称")
    @TableField("UPDATE_ORG_NAME_")
    private String updateOrgName;

    @ApiModelProperty(value = "更新时间")
    @TableField("UPDATE_TIME_")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField("LAST_TIME_")
    private Long lastTime;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getOutManifestUserId() {
        return outManifestUserId;
    }

    public void setOutManifestUserId(String outManifestUserId) {
        this.outManifestUserId = outManifestUserId;
    }
    public String getOutManifestUserName() {
        return outManifestUserName;
    }

    public void setOutManifestUserName(String outManifestUserName) {
        this.outManifestUserName = outManifestUserName;
    }
    public String getOutManifestUserPhone() {
        return outManifestUserPhone;
    }

    public void setOutManifestUserPhone(String outManifestUserPhone) {
        this.outManifestUserPhone = outManifestUserPhone;
    }
    public String getOutManifestCompanyId() {
        return outManifestCompanyId;
    }

    public void setOutManifestCompanyId(String outManifestCompanyId) {
        this.outManifestCompanyId = outManifestCompanyId;
    }
    public String getOutManifestCompanyName() {
        return outManifestCompanyName;
    }

    public void setOutManifestCompanyName(String outManifestCompanyName) {
        this.outManifestCompanyName = outManifestCompanyName;
    }
    public LocalDate getOutManifestDate() {
        return outManifestDate;
    }

    public void setOutManifestDate(LocalDate outManifestDate) {
        this.outManifestDate = outManifestDate;
    }
    public String getOutManifestAddress() {
        return outManifestAddress;
    }

    public void setOutManifestAddress(String outManifestAddress) {
        this.outManifestAddress = outManifestAddress;
    }
    public String getBizOutManifestId() {
        return bizOutManifestId;
    }

    public void setBizOutManifestId(String bizOutManifestId) {
        this.bizOutManifestId = bizOutManifestId;
    }
    public String getSettlementNum() {
        return settlementNum;
    }

    public void setSettlementNum(String settlementNum) {
        this.settlementNum = settlementNum;
    }
    public BigDecimal getOutManifestAmount() {
        return outManifestAmount;
    }

    public void setOutManifestAmount(BigDecimal outManifestAmount) {
        this.outManifestAmount = outManifestAmount;
    }
    public LocalDate getInManifestDate() {
        return inManifestDate;
    }

    public void setInManifestDate(LocalDate inManifestDate) {
        this.inManifestDate = inManifestDate;
    }
    public Integer getInvoiceStatus() {
        return invoiceStatus;
    }

    public void setInvoiceStatus(Integer invoiceStatus) {
        this.invoiceStatus = invoiceStatus;
    }
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
    public String getContractItemId() {
        return contractItemId;
    }

    public void setContractItemId(String contractItemId) {
        this.contractItemId = contractItemId;
    }
    public String getHandleNoticeId() {
        return handleNoticeId;
    }

    public void setHandleNoticeId(String handleNoticeId) {
        this.handleNoticeId = handleNoticeId;
    }
    public String getHandleNoticeDetailedId() {
        return handleNoticeDetailedId;
    }

    public void setHandleNoticeDetailedId(String handleNoticeDetailedId) {
        this.handleNoticeDetailedId = handleNoticeDetailedId;
    }
    public String getMatCategoryId() {
        return matCategoryId;
    }

    public void setMatCategoryId(String matCategoryId) {
        this.matCategoryId = matCategoryId;
    }
    public String getMatCategoryName() {
        return matCategoryName;
    }

    public void setMatCategoryName(String matCategoryName) {
        this.matCategoryName = matCategoryName;
    }
    public String getHandleDetailedId() {
        return handleDetailedId;
    }

    public void setHandleDetailedId(String handleDetailedId) {
        this.handleDetailedId = handleDetailedId;
    }
    public String getMatId() {
        return matId;
    }

    public void setMatId(String matId) {
        this.matId = matId;
    }
    public String getMatPlatcode() {
        return matPlatcode;
    }

    public void setMatPlatcode(String matPlatcode) {
        this.matPlatcode = matPlatcode;
    }
    public String getMatName() {
        return matName;
    }

    public void setMatName(String matName) {
        this.matName = matName;
    }
    public String getMatMaterial() {
        return matMaterial;
    }

    public void setMatMaterial(String matMaterial) {
        this.matMaterial = matMaterial;
    }
    public String getMatSpec() {
        return matSpec;
    }

    public void setMatSpec(String matSpec) {
        this.matSpec = matSpec;
    }
    public String getMatUnit() {
        return matUnit;
    }

    public void setMatUnit(String matUnit) {
        this.matUnit = matUnit;
    }
    public String getMatBaseExt() {
        return matBaseExt;
    }

    public void setMatBaseExt(String matBaseExt) {
        this.matBaseExt = matBaseExt;
    }
    public String getMatOtherExt() {
        return matOtherExt;
    }

    public void setMatOtherExt(String matOtherExt) {
        this.matOtherExt = matOtherExt;
    }
    public String getMatBrand() {
        return matBrand;
    }

    public void setMatBrand(String matBrand) {
        this.matBrand = matBrand;
    }
    public String getBuyDate() {
        return buyDate;
    }

    public void setBuyDate(String buyDate) {
        this.buyDate = buyDate;
    }
    public String getInsurancePeriodEnd() {
        return insurancePeriodEnd;
    }

    public void setInsurancePeriodEnd(String insurancePeriodEnd) {
        this.insurancePeriodEnd = insurancePeriodEnd;
    }
    public String getDisplacement() {
        return displacement;
    }

    public void setDisplacement(String displacement) {
        this.displacement = displacement;
    }
    public String getInspectionValidity() {
        return inspectionValidity;
    }

    public void setInspectionValidity(String inspectionValidity) {
        this.inspectionValidity = inspectionValidity;
    }
    public String getOriginalValue() {
        return originalValue;
    }

    public void setOriginalValue(String originalValue) {
        this.originalValue = originalValue;
    }
    public Double getNum() {
        return num;
    }

    public void setNum(Double num) {
        this.num = num;
    }
    public BigDecimal getBasePrice() {
        return basePrice;
    }

    public void setBasePrice(BigDecimal basePrice) {
        this.basePrice = basePrice;
    }
    public Double getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(Double taxRate) {
        this.taxRate = taxRate;
    }
    public Integer getAuctionMethod() {
        return auctionMethod;
    }

    public void setAuctionMethod(Integer auctionMethod) {
        this.auctionMethod = auctionMethod;
    }
    public BigDecimal getTransactionPrice() {
        return transactionPrice;
    }

    public void setTransactionPrice(BigDecimal transactionPrice) {
        this.transactionPrice = transactionPrice;
    }
    public BigDecimal getBiddingMaxPrice() {
        return biddingMaxPrice;
    }

    public void setBiddingMaxPrice(BigDecimal biddingMaxPrice) {
        this.biddingMaxPrice = biddingMaxPrice;
    }
    public BigDecimal getBond() {
        return bond;
    }

    public void setBond(BigDecimal bond) {
        this.bond = bond;
    }
    public Integer getWinnerUserRanking() {
        return winnerUserRanking;
    }

    public void setWinnerUserRanking(Integer winnerUserRanking) {
        this.winnerUserRanking = winnerUserRanking;
    }
    public BigDecimal getTransactionServiceFee() {
        return transactionServiceFee;
    }

    public void setTransactionServiceFee(BigDecimal transactionServiceFee) {
        this.transactionServiceFee = transactionServiceFee;
    }
    public Integer getHasQualifications() {
        return hasQualifications;
    }

    public void setHasQualifications(Integer hasQualifications) {
        this.hasQualifications = hasQualifications;
    }
    public String getInManifestUserId() {
        return inManifestUserId;
    }

    public void setInManifestUserId(String inManifestUserId) {
        this.inManifestUserId = inManifestUserId;
    }
    public String getInManifestUserName() {
        return inManifestUserName;
    }

    public void setInManifestUserName(String inManifestUserName) {
        this.inManifestUserName = inManifestUserName;
    }
    public String getInManifestUserPhone() {
        return inManifestUserPhone;
    }

    public void setInManifestUserPhone(String inManifestUserPhone) {
        this.inManifestUserPhone = inManifestUserPhone;
    }
    public String getInManifestCompanyId() {
        return inManifestCompanyId;
    }

    public void setInManifestCompanyId(String inManifestCompanyId) {
        this.inManifestCompanyId = inManifestCompanyId;
    }
    public String getInManifestCompanyName() {
        return inManifestCompanyName;
    }

    public void setInManifestCompanyName(String inManifestCompanyName) {
        this.inManifestCompanyName = inManifestCompanyName;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }
    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }
    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }
    public String getCreateOrgName() {
        return createOrgName;
    }

    public void setCreateOrgName(String createOrgName) {
        this.createOrgName = createOrgName;
    }
    public String getCreateCompanyId() {
        return createCompanyId;
    }

    public void setCreateCompanyId(String createCompanyId) {
        this.createCompanyId = createCompanyId;
    }
    public String getCreateCompanyName() {
        return createCompanyName;
    }

    public void setCreateCompanyName(String createCompanyName) {
        this.createCompanyName = createCompanyName;
    }
    public String getCreateOrgId() {
        return createOrgId;
    }

    public void setCreateOrgId(String createOrgId) {
        this.createOrgId = createOrgId;
    }
    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }
    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }
    public String getUpdateName() {
        return updateName;
    }

    public void setUpdateName(String updateName) {
        this.updateName = updateName;
    }
    public String getUpdateCompanyName() {
        return updateCompanyName;
    }

    public void setUpdateCompanyName(String updateCompanyName) {
        this.updateCompanyName = updateCompanyName;
    }
    public String getUpdateCompanyId() {
        return updateCompanyId;
    }

    public void setUpdateCompanyId(String updateCompanyId) {
        this.updateCompanyId = updateCompanyId;
    }
    public String getUpdateOrgId() {
        return updateOrgId;
    }

    public void setUpdateOrgId(String updateOrgId) {
        this.updateOrgId = updateOrgId;
    }
    public String getUpdateOrgName() {
        return updateOrgName;
    }

    public void setUpdateOrgName(String updateOrgName) {
        this.updateOrgName = updateOrgName;
    }
    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }
    public Long getLastTime() {
        return lastTime;
    }

    public void setLastTime(Long lastTime) {
        this.lastTime = lastTime;
    }
    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }
    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    protected Serializable pkVal() {
        return null;
    }

    @Override
    public String toString() {
        return "BizOutManifestDetailedNew{" +
            "id=" + id +
            ", outManifestUserId=" + outManifestUserId +
            ", outManifestUserName=" + outManifestUserName +
            ", outManifestUserPhone=" + outManifestUserPhone +
            ", outManifestCompanyId=" + outManifestCompanyId +
            ", outManifestCompanyName=" + outManifestCompanyName +
            ", outManifestDate=" + outManifestDate +
            ", outManifestAddress=" + outManifestAddress +
            ", bizOutManifestId=" + bizOutManifestId +
            ", settlementNum=" + settlementNum +
            ", outManifestAmount=" + outManifestAmount +
            ", inManifestDate=" + inManifestDate +
            ", invoiceStatus=" + invoiceStatus +
            ", status=" + status +
            ", contractId=" + contractId +
            ", contractItemId=" + contractItemId +
            ", handleNoticeId=" + handleNoticeId +
            ", handleNoticeDetailedId=" + handleNoticeDetailedId +
            ", matCategoryId=" + matCategoryId +
            ", matCategoryName=" + matCategoryName +
            ", handleDetailedId=" + handleDetailedId +
            ", matId=" + matId +
            ", matPlatcode=" + matPlatcode +
            ", matName=" + matName +
            ", matMaterial=" + matMaterial +
            ", matSpec=" + matSpec +
            ", matUnit=" + matUnit +
            ", matBaseExt=" + matBaseExt +
            ", matOtherExt=" + matOtherExt +
            ", matBrand=" + matBrand +
            ", buyDate=" + buyDate +
            ", insurancePeriodEnd=" + insurancePeriodEnd +
            ", displacement=" + displacement +
            ", inspectionValidity=" + inspectionValidity +
            ", originalValue=" + originalValue +
            ", num=" + num +
            ", basePrice=" + basePrice +
            ", taxRate=" + taxRate +
            ", auctionMethod=" + auctionMethod +
            ", transactionPrice=" + transactionPrice +
            ", biddingMaxPrice=" + biddingMaxPrice +
            ", bond=" + bond +
            ", winnerUserRanking=" + winnerUserRanking +
            ", transactionServiceFee=" + transactionServiceFee +
            ", hasQualifications=" + hasQualifications +
            ", inManifestUserId=" + inManifestUserId +
            ", inManifestUserName=" + inManifestUserName +
            ", inManifestUserPhone=" + inManifestUserPhone +
            ", inManifestCompanyId=" + inManifestCompanyId +
            ", inManifestCompanyName=" + inManifestCompanyName +
            ", remarks=" + remarks +
            ", isDele=" + isDele +
            ", createBy=" + createBy +
            ", createName=" + createName +
            ", createOrgName=" + createOrgName +
            ", createCompanyId=" + createCompanyId +
            ", createCompanyName=" + createCompanyName +
            ", createOrgId=" + createOrgId +
            ", createTime=" + createTime +
            ", updateBy=" + updateBy +
            ", updateName=" + updateName +
            ", updateCompanyName=" + updateCompanyName +
            ", updateCompanyId=" + updateCompanyId +
            ", updateOrgId=" + updateOrgId +
            ", updateOrgName=" + updateOrgName +
            ", updateTime=" + updateTime +
            ", lastTime=" + lastTime +
            ", version=" + version +
            ", tenantId=" + tenantId +
        "}";
    }
}
