package com.artfess.cgpt.order.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description:支付平台支付记录VO
 * @Author: Rong Tao
 * @Date: 2024/5/22 18:08
 */
@Data
public class TransVo implements Serializable {

    @ApiModelProperty(value = "流水号（批次号）")
    private String statementsCode;

    @ApiModelProperty(value = "支付单位ID")
    private String payUnitId;

    @ApiModelProperty(value = "支付单位编号")
    private String payUnitCode;

    @ApiModelProperty(value = "支付单位名称")
    private String payUnitName;

    @ApiModelProperty(value = "支付账号")
    private String payAccount;

    @ApiModelProperty(value = "支付账号开户行")
    private String payAccountBank;

    @ApiModelProperty(value = "支付金额")
    private BigDecimal payAmount;

    @ApiModelProperty(value = "支付时间")
    private LocalDateTime payTime;

    @ApiModelProperty(value = "收款到账时间")
    private LocalDateTime collectTime;

    @ApiModelProperty(value = "支付时间戳")
    private Long payTimer;

    @ApiModelProperty(value = "支付方式（使用字典，1：线上支付，2：线下支付）")
    private Integer payMethod;

    @ApiModelProperty(value = "支付描述")
    private String payDescribe;

    @ApiModelProperty(value = "费用类型（1：会员费，2：保证金，3：合同预付款，4：货款，5：标书费，" +
            "6：退还保证金，7：退款，8：提现，9：余额充值，10：交易服务费，" +
            "11：人工核对，12：没收保证金，13：预缴会员费，14：资格审查费，15：合同服务费，16：开票服务费）")
    private Integer payType;

    @ApiModelProperty(value = "收款单位ID")
    private String collectUnitId;

    @ApiModelProperty(value = "收款单位编号")
    private String collectUnitCode;

    @ApiModelProperty(value = "收款单位名称")
    private String collectUnitName;

    @ApiModelProperty(value = "收款账号")
    private String collectAccount;

    @ApiModelProperty(value = "收款账号开户行")
    private String collectAccountBank;

    @ApiModelProperty(value = "系统标识（数据来源）")
    private String sysCode;

    @ApiModelProperty(value = "系统名称")
    private String sysName;

    @ApiModelProperty(value = "收款到账时间戳")
    private Long collectTimer;

    @ApiModelProperty(value = "支付状态（1：未支付，2：支付中，3：已支付）")
    private Integer depositPaymentStatus;

    @ApiModelProperty(value = "退款状态（1：未退款，2：退款中，3：已退款）")
    private Integer refundStatus;

    @ApiModelProperty(value = "退款记录ID")
    private String refundTransId;

    @ApiModelProperty(value = "订单明细")
    @TableField(exist = false)
    private List<OrderDetailsVo> orderDetails;
//
//    @ApiModelProperty(value = "支付方税号")
//    @TableField(exist = false)
//    private String payTaxNumber;

}
