package com.artfess.cgpt.order.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 订单交易明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
@ApiModel(value="BizRegistrationOrderDetails对象", description="订单交易明细表")
@TableName("biz_registration_order_details")
@Data
public class BizRegistrationOrderDetails extends BizNoModel<BizRegistrationOrderDetails> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "订单ID")
    @TableField("REGISTRATION_ORDER_ID_")
    private String registrationOrderId;

    @ApiModelProperty(value = "订单号")
    @TableField("REGISTRATION_ORDER_NUMBER_")
    private String registrationOrderNumber;

    @ApiModelProperty(value = "用户姓名")
    @TableField("USER_ID_")
    private String userId;

    @ApiModelProperty(value = "用户账号")
    @TableField("USER_NAME_")
    private String userName;

    @ApiModelProperty(value = "用户账号")
    @TableField("USER_ACCOUNT_")
    private String userAccount;

    @ApiModelProperty(value = "用户所属公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "用户所属公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "用户所属公司编码")
    @TableField("COMPANY_CODE_")
    private String companyCode;

    @ApiModelProperty(value = "联系方式")
    @TableField("USER_PHONE_")
    private String userPhone;

    @ApiModelProperty(value = "立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "立项名称")
    @TableField("NOTICE_TITLE_")
    private String noticeTitle;

    @ApiModelProperty(value = "立项类型（1：物料，2：项目）")
    @TableField("NOTICE_TYPE_")
    private Integer noticeType;

    @ApiModelProperty(value = "立项明细ID，关联立项明细表ID")
    @TableField("DETAILED_ID_")
    private String detailedId;

    @ApiModelProperty(value = "收费名称（项目名称/物料名称）")
    @TableField("PAY_NAME_")
    private String payName;

    @ApiModelProperty(value = "订单数量")
    @TableField("RECHARGE_NUMBER_")
    private BigDecimal rechargeNumber;

    @ApiModelProperty(value = "订单金额")
    @TableField("RECHARGE_PRICE_")
    private BigDecimal rechargePrice;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "销售方公司ID")
    @TableField("SALES_COMPANY_ID_")
    private String salesCompanyId;

    @ApiModelProperty(value = "销售方公司编号")
    @TableField("SALES_COMPANY_CODE_")
    private String salesCompanyCode;

    @ApiModelProperty(value = "销售方公司名称")
    @TableField("SALES_COMPANY_NAME_")
    private String salesCompanyName;

    @ApiModelProperty(value = "物料编号")
    @TableField("MAT_CODE_")
    private String matCode;

    @ApiModelProperty(value = "规格型号")
    @TableField("SPECIFICATION_")
    private String specification;

    @ApiModelProperty(value = "单价")
    @TableField("PRICE_")
    private BigDecimal price;

    @ApiModelProperty(value = "单位")
    @TableField("UNIT_")
    private String unit;

    @ApiModelProperty(value = "含税标志（0：不含税 ，1：含税， 默认1）")
    @TableField("IS_TAX_")
    private Integer isTax;

    @ApiModelProperty(value = "税率（整数）")
    @TableField("TAX_RATE_")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "税额")
    @TableField("TAX_AMOUNT_")
    private BigDecimal taxAmount;

}
